/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates;

import com.github.se7_kn8.gates.Gates;
import com.github.se7_kn8.gates.GatesItems;
import com.github.se7_kn8.gates.block.CustomDetector;
import com.github.se7_kn8.gates.block.CustomRepeater;
import com.github.se7_kn8.gates.block.OneInputLogicGate;
import com.github.se7_kn8.gates.block.RSFlipFlop;
import com.github.se7_kn8.gates.block.RotarySwitch;
import com.github.se7_kn8.gates.block.TwoInputLogicGate;
import com.github.se7_kn8.gates.block.WaxedRedstone;
import com.github.se7_kn8.gates.block.redstone_clock.AdvancedRedstoneClock;
import com.github.se7_kn8.gates.block.redstone_clock.RedstoneClock;
import com.github.se7_kn8.gates.block.wireless_redstone.ReceiverBlock;
import com.github.se7_kn8.gates.block.wireless_redstone.TransmitterBlock;
import com.github.se7_kn8.gates.block.wireless_redstone.WirelessRedstoneLamp;
import com.github.se7_kn8.gates.tile.CustomDetectorTile;
import com.github.se7_kn8.gates.tile.ReceiverTileEntity;
import com.github.se7_kn8.gates.tile.RedstoneClockTileEntity;
import com.github.se7_kn8.gates.tile.TransmitterTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class GatesBlocks {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"gates");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"gates");
    public static final RegistryObject<Block> REDSTONE_BLOCK_OFF = GatesBlocks.addBlock("redstone_block_off", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150451_bX)), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> AND_GATE = GatesBlocks.addBlock("and_gate", () -> new TwoInputLogicGate((x1, x2) -> x1 != false && x2 != false), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> OR_GATE = GatesBlocks.addBlock("or_gate", () -> new TwoInputLogicGate((x1, x2) -> x1 != false || x2 != false), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> NAND_GATE = GatesBlocks.addBlock("nand_gate", () -> new TwoInputLogicGate((x1, x2) -> x1 == false || x2 == false), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> NOR_GATE = GatesBlocks.addBlock("nor_gate", () -> new TwoInputLogicGate((x1, x2) -> x1 == false && x2 == false), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> XOR_GATE = GatesBlocks.addBlock("xor_gate", () -> new TwoInputLogicGate((x1, x2) -> x1 ^ x2), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> XNOR_GATE = GatesBlocks.addBlock("xnor_gate", () -> new TwoInputLogicGate((x1, x2) -> !(x1 ^ x2)), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> NOT_GATE = GatesBlocks.addBlock("not_gate", () -> new OneInputLogicGate(x1 -> x1 == false), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> FAST_REPEATER = GatesBlocks.addBlock("fast_repeater", () -> new CustomRepeater(1), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> SLOW_REPEATER = GatesBlocks.addBlock("slow_repeater", () -> new CustomRepeater(4), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> WIRELESS_REDSTONE_RECEIVER = GatesBlocks.addBlock("receiver", ReceiverBlock::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> WIRELESS_REDSTONE_TRANSMITTER = GatesBlocks.addBlock("transmitter", TransmitterBlock::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> WIRELESS_REDSTONE_LAMP = GatesBlocks.addBlock("wireless_redstone_lamp", WirelessRedstoneLamp::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> RAIN_DETECTOR = GatesBlocks.addBlock("rain_detector", () -> new CustomDetector((blockState, world, blockPos) -> world.func_175727_C(blockPos.func_177981_b(2)) ? 15 : 0), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> THUNDER_DETECTOR = GatesBlocks.addBlock("thunder_detector", () -> new CustomDetector((blockState, world, blockPos) -> world.func_72911_I() ? 15 : 0), Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> REDSTONE_CLOCK = GatesBlocks.addBlock("redstone_clock", RedstoneClock::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> ADVANCED_REDSTONE_CLOCK = GatesBlocks.addBlock("advanced_redstone_clock", AdvancedRedstoneClock::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> ROTARY_SWITCH = GatesBlocks.addBlock("rotary_switch", RotarySwitch::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> RS_FLIP_FLOP = GatesBlocks.addBlock("rs_flip_flop", RSFlipFlop::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<Block> WAXED_REDSTONE_WIRE = GatesBlocks.addBlock("waxed_redstone_wire", WaxedRedstone::new, Gates.GATES_ITEM_GROUP);
    public static final RegistryObject<TileEntityType<CustomDetectorTile>> RAIN_DETECTOR_TILE_ENTITY = GatesBlocks.addTileEntity("rain_detector", CustomDetectorTile::new, new Supplier[]{RAIN_DETECTOR, THUNDER_DETECTOR});
    public static final RegistryObject<TileEntityType<ReceiverTileEntity>> RECEIVER_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("receiver", ReceiverTileEntity::new, new Supplier[]{WIRELESS_REDSTONE_RECEIVER});
    public static final RegistryObject<TileEntityType<TransmitterTileEntity>> TRANSMITTER_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("transmitter", TransmitterTileEntity::new, new Supplier[]{WIRELESS_REDSTONE_TRANSMITTER, WIRELESS_REDSTONE_LAMP});
    public static final RegistryObject<TileEntityType<RedstoneClockTileEntity>> REDSTONE_CLOCK_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("redstone_clock", RedstoneClockTileEntity::new, new Supplier[]{REDSTONE_CLOCK, ADVANCED_REDSTONE_CLOCK});

    private static <T extends Block> RegistryObject<T> addBlock(String name, Supplier<T> block, ItemGroup tab) {
        RegistryObject object = BLOCKS.register(name, block);
        GatesItems.ITEMS.register(name, () -> {
            BlockItem itemBlock = new BlockItem((Block)object.get(), new Item.Properties().func_200916_a(tab));
            itemBlock.func_195946_a(Item.field_179220_a, (Item)itemBlock);
            return itemBlock;
        });
        return object;
    }

    @SafeVarargs
    private static <T extends TileEntity> RegistryObject<TileEntityType<T>> addTileEntity(String name, Supplier<T> tileEntitySupplier, Supplier<? extends Block> ... validBlocksSuppliers) {
        return TILE_ENTITIES.register(name, () -> {
            Block[] blocks = new Block[validBlocksSuppliers.length];
            for (int i = 0; i < validBlocksSuppliers.length; ++i) {
                blocks[i] = (Block)validBlocksSuppliers[i].get();
            }
            return TileEntityType.Builder.func_223042_a((Supplier)tileEntitySupplier, (Block[])blocks).func_206865_a(null);
        });
    }
}

