/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.block.wireless_redstone;

import com.github.se7_kn8.gates.api.CapabilityUtil;
import com.github.se7_kn8.gates.api.IWirelessNode;
import com.github.se7_kn8.gates.data.RedstoneReceiverWorldSavedData;
import com.github.se7_kn8.gates.item.FrequencyChangerItem;
import com.github.se7_kn8.gates.tile.TransmitterTileEntity;
import com.github.se7_kn8.gates.util.Utils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.network.NetworkHooks;

public class TransmitterBlock
extends ContainerBlock {
    public static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Utils.GATE_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0));
    public static IntegerProperty POWER = BlockStateProperties.field_208136_ak;

    public TransmitterBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196633_cV));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity entity;
        if (player.func_184586_b(handIn).func_77973_b() instanceof FrequencyChangerItem && player.func_184586_b(handIn).func_77942_o() && player.func_184586_b(handIn).func_77978_p().func_74764_b("frequency")) {
            return ActionResultType.PASS;
        }
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TransmitterTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)entity), (BlockPos)entity.func_174877_v());
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return TransmitterBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.field_72995_K && state.func_177230_c() != oldState.func_177230_c()) {
            RedstoneReceiverWorldSavedData data = RedstoneReceiverWorldSavedData.get((ServerWorld)worldIn);
            data.addNode(worldIn, pos);
            this.update(worldIn, pos, state);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.field_72995_K && newState.func_177230_c() != state.func_177230_c()) {
            RedstoneReceiverWorldSavedData.get((ServerWorld)worldIn).removeNode(worldIn, pos);
            CapabilityUtil.findWirelessCapability(worldIn, pos, (NonNullConsumer<IWirelessNode>)((NonNullConsumer)c -> RedstoneReceiverWorldSavedData.get((ServerWorld)worldIn).updateFrequency(worldIn, c.getFrequency())));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TransmitterTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)POWER) > 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 5);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random p_225534_4_) {
        this.update((World)world, pos, state);
    }

    private void update(World worldIn, BlockPos pos, BlockState state) {
        int power = this.findMaxPower(worldIn, pos);
        this.updateFrequency((ServerWorld)worldIn, pos);
        if (power != (Integer)state.func_177229_b((Property)POWER)) {
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(power)));
        }
    }

    public void updateFrequency(ServerWorld world, BlockPos pos, int oldFrequency) {
        RedstoneReceiverWorldSavedData.get(world).updateFrequency((World)world, oldFrequency);
        this.updateFrequency(world, pos);
    }

    public void updateFrequency(ServerWorld world, BlockPos pos) {
        int power = this.findMaxPower((World)world, pos);
        CapabilityUtil.findWirelessCapability((World)world, pos, (NonNullConsumer<IWirelessNode>)((NonNullConsumer)c -> {
            c.setPower(power);
            RedstoneReceiverWorldSavedData.get(world).updateFrequency((World)world, c.getFrequency());
        }));
    }

    private int findMaxPower(World world, BlockPos pos) {
        int currentMax = 0;
        if (world.func_175651_c(pos.func_177978_c(), Direction.NORTH) > currentMax) {
            currentMax = world.func_175651_c(pos.func_177978_c(), Direction.NORTH);
        }
        if (world.func_175651_c(pos.func_177974_f(), Direction.EAST) > currentMax) {
            currentMax = world.func_175651_c(pos.func_177974_f(), Direction.EAST);
        }
        if (world.func_175651_c(pos.func_177968_d(), Direction.SOUTH) > currentMax) {
            currentMax = world.func_175651_c(pos.func_177968_d(), Direction.SOUTH);
        }
        if (world.func_175651_c(pos.func_177976_e(), Direction.WEST) > currentMax) {
            currentMax = world.func_175651_c(pos.func_177976_e(), Direction.WEST);
        }
        return currentMax;
    }
}

