/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.data_gen;

import com.github.se7_kn8.gates.GatesBlocks;
import com.github.se7_kn8.gates.block.CustomDetector;
import com.github.se7_kn8.gates.block.CustomRepeater;
import com.github.se7_kn8.gates.block.OneInputLogicGate;
import com.github.se7_kn8.gates.block.RSFlipFlop;
import com.github.se7_kn8.gates.block.RotarySwitch;
import com.github.se7_kn8.gates.block.TwoInputLogicGate;
import com.github.se7_kn8.gates.block.WaxedRedstone;
import com.github.se7_kn8.gates.block.redstone_clock.AdvancedRedstoneClock;
import com.github.se7_kn8.gates.block.redstone_clock.RedstoneClock;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "gates", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.cubeAll((Block)GatesBlocks.REDSTONE_BLOCK_OFF.get(), this.modLoc("block/redstone_block_off"));
        this.gateModel((Block)GatesBlocks.AND_GATE.get());
        this.gateModel((Block)GatesBlocks.OR_GATE.get());
        this.gateModel((Block)GatesBlocks.XOR_GATE.get());
        this.gateModel((Block)GatesBlocks.NAND_GATE.get());
        this.gateModel((Block)GatesBlocks.NOR_GATE.get());
        this.gateModel((Block)GatesBlocks.XNOR_GATE.get());
        this.notGate((Block)GatesBlocks.NOT_GATE.get());
        this.detectorModel((Block)GatesBlocks.RAIN_DETECTOR.get());
        this.detectorModel((Block)GatesBlocks.THUNDER_DETECTOR.get());
        this.wirelessRedstoneModel((Block)GatesBlocks.WIRELESS_REDSTONE_TRANSMITTER.get());
        this.wirelessRedstoneModel((Block)GatesBlocks.WIRELESS_REDSTONE_RECEIVER.get());
        this.lamp((Block)GatesBlocks.WIRELESS_REDSTONE_LAMP.get());
        this.redstoneClock((Block)GatesBlocks.REDSTONE_CLOCK.get());
        this.advancedRedstoneClock((Block)GatesBlocks.ADVANCED_REDSTONE_CLOCK.get());
        this.rsFlipFlop((Block)GatesBlocks.RS_FLIP_FLOP.get());
        this.rotarySwitch((Block)GatesBlocks.ROTARY_SWITCH.get());
        this.repeater((Block)GatesBlocks.FAST_REPEATER.get());
        this.repeater((Block)GatesBlocks.SLOW_REPEATER.get());
        this.waxedRedstone((Block)GatesBlocks.WAXED_REDSTONE_WIRE.get());
    }

    private void cubeAll(Block b, ResourceLocation texture) {
        this.simpleBlock(b);
        this.simpleBlockItem(b, (ModelFile)this.models().cubeAll(b.getRegistryName().func_110623_a(), texture));
    }

    private void simpleItem(String name) {
        this.itemModels().singleTexture(name, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + name));
    }

    private ModelFile getTorchModel(String name, boolean on) {
        if (on) {
            return ((BlockModelBuilder)this.models().withExistingParent("block/torch/" + name + "_on", this.modLoc("block/torch/" + name))).texture("texture", this.mcLoc("block/redstone_torch"));
        }
        return ((BlockModelBuilder)this.models().withExistingParent("block/torch/" + name + "_off", this.modLoc("block/torch/" + name))).texture("texture", this.mcLoc("block/redstone_torch_off"));
    }

    private void detectorModel(Block b) {
        String name = b.getRegistryName().func_110623_a();
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        ModelBuilder detector = ((BlockModelBuilder)this.models().withExistingParent("block/sensor/" + name, this.modLoc("block/sensor/basic_detector"))).texture("top", this.modLoc("block/" + name + "_top"));
        ModelBuilder detector_inverted = ((BlockModelBuilder)this.models().withExistingParent("block/sensor/" + name + "_inverted", this.modLoc("block/sensor/basic_detector"))).texture("top", this.modLoc("block/" + name + "_top_inverted"));
        builder.forAllStatesExcept(arg_0 -> BlockStates.lambda$detectorModel$0((ModelFile)detector_inverted, (ModelFile)detector, arg_0), new Property[]{CustomDetector.POWER});
        this.simpleBlockItem(b, (ModelFile)detector);
    }

    private void gateModel(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        String name = b.getRegistryName().func_110623_a();
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/gate/" + name, this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/" + name));
        ModelFile leftTorchOn = this.getTorchModel("left_torch", true);
        ModelFile leftTorchOff = this.getTorchModel("left_torch", false);
        ModelFile rightTorchOn = this.getTorchModel("right_torch", true);
        ModelFile rightTorchOff = this.getTorchModel("right_torch", false);
        ModelFile outputTorchOn = this.getTorchModel("output_torch", true);
        ModelFile outputTorchOff = this.getTorchModel("output_torch", false);
        for (Direction dir : TwoInputLogicGate.field_185512_D.func_177700_c()) {
            int yRot = (int)dir.func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModel).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leftTorchOn).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.LEFT_INPUT, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leftTorchOff).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.LEFT_INPUT, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(rightTorchOn).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.RIGHT_INPUT, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(rightTorchOff).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.RIGHT_INPUT, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(outputTorchOn).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.field_196348_c, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(outputTorchOff).rotationY(yRot).addModel()).condition((Property)TwoInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)TwoInputLogicGate.field_196348_c, (Comparable[])new Boolean[]{false});
        }
        this.simpleItem(name);
    }

    private void notGate(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        String name = b.getRegistryName().func_110623_a();
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/gate/" + name, this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/" + name));
        ModelFile inputTorchOn = this.getTorchModel("input_torch", true);
        ModelFile inputTorchOff = this.getTorchModel("input_torch", false);
        ModelFile outputTorchOn = this.getTorchModel("output_torch", true);
        ModelFile outputTorchOff = this.getTorchModel("output_torch", false);
        for (Direction dir : OneInputLogicGate.field_185512_D.func_177700_c()) {
            int yRot = (int)dir.func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModel).rotationY(yRot).addModel()).condition((Property)OneInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(inputTorchOn).rotationY(yRot).addModel()).condition((Property)OneInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)OneInputLogicGate.INPUT, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(inputTorchOff).rotationY(yRot).addModel()).condition((Property)OneInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)OneInputLogicGate.INPUT, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(outputTorchOn).rotationY(yRot).addModel()).condition((Property)OneInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)OneInputLogicGate.field_196348_c, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(outputTorchOff).rotationY(yRot).addModel()).condition((Property)OneInputLogicGate.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)OneInputLogicGate.field_196348_c, (Comparable[])new Boolean[]{false});
        }
        this.simpleItem(name);
    }

    private void wirelessRedstoneModel(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        String name = b.getRegistryName().func_110623_a();
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/wireless/" + name, this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/" + name));
        ModelFile mainTorchOn = this.getTorchModel("main_torch", true);
        ModelFile mainTorchOff = this.getTorchModel("main_torch", false);
        builder.part().modelFile((ModelFile)baseModel).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorchOn).addModel()).condition((Property)BlockStateProperties.field_208136_ak, (Comparable[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorchOff).addModel()).condition((Property)BlockStateProperties.field_208136_ak, (Comparable[])new Integer[]{0});
        this.simpleItem(name);
    }

    private void redstoneClock(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        ModelFile mainTorch1On = this.getTorchModel("main_torch_1", true);
        ModelFile mainTorch1Off = this.getTorchModel("main_torch_1", false);
        ModelFile mainTorch2On = this.getTorchModel("main_torch_2", true);
        ModelFile mainTorch2Off = this.getTorchModel("main_torch_2", false);
        ModelFile mainTorch3On = this.getTorchModel("main_torch_3", true);
        ModelFile mainTorch3Off = this.getTorchModel("main_torch_3", false);
        ModelFile mainTorch4On = this.getTorchModel("main_torch_4", true);
        ModelFile mainTorch4Off = this.getTorchModel("main_torch_4", false);
        ModelFile mainTorch5On = this.getTorchModel("main_torch_5", true);
        ModelFile mainTorch5Off = this.getTorchModel("main_torch_5", false);
        ModelBuilder base = ((BlockModelBuilder)this.models().withExistingParent("block/redstone_clock/redstone_clock", this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/redstone_clock"));
        builder.part().modelFile((ModelFile)base).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch1Off).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{1}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch1On).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{1}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch2Off).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{2}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch2On).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{2}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch3Off).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{3}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch3On).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{3}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch4Off).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{4}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch4On).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{4}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch5Off).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{5}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch5On).addModel()).condition((Property)RedstoneClock.CLOCK_SPEED, (Comparable[])new Integer[]{5}).condition((Property)RedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        this.simpleItem(b.getRegistryName().func_110623_a());
    }

    private void advancedRedstoneClock(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        ModelFile inputTorchOn = this.getTorchModel("input_torch", true);
        ModelFile inputTorchOff = this.getTorchModel("input_torch", false);
        ModelFile mainTorch1On = this.getTorchModel("main_torch_1", true);
        ModelFile mainTorch5Off = this.getTorchModel("main_torch_5", false);
        ModelBuilder baseModelOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/redstone_clock/advanced_redstone_clock_on", this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/advanced_redstone_clock_on"))).texture("slab", this.mcLoc("block/gold_block"));
        ModelBuilder baseModelOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/redstone_clock/advanced_redstone_clock_off", this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/advanced_redstone_clock_off"))).texture("slab", this.mcLoc("block/gold_block"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModelOn).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModelOff).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch1On).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(mainTorch5Off).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
            int yRot = (int)dir.func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(inputTorchOn).rotationY(yRot).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(inputTorchOff).rotationY(yRot).addModel()).condition((Property)AdvancedRedstoneClock.POWERED, (Comparable[])new Boolean[]{false});
        }
        this.simpleItem(b.getRegistryName().func_110623_a());
    }

    private void rsFlipFlop(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/rs_flip_flop", this.modLoc("block/gate/basic_gate"))).texture("top", this.modLoc("block/nor_gate"));
        ModelBuilder smallRedstoneBlockOn = ((BlockModelBuilder)this.models().withExistingParent("block/redstone_block/small_redstone_block_on", this.modLoc("block/redstone_block/small_redstone_block"))).texture("block", this.mcLoc("block/redstone_block"));
        ModelBuilder smallRedstoneBlockOff = ((BlockModelBuilder)this.models().withExistingParent("block/redstone_block/small_redstone_block_off", this.modLoc("block/redstone_block/small_redstone_block"))).texture("block", this.modLoc("block/redstone_block_off"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)smallRedstoneBlockOn).addModel()).condition((Property)RSFlipFlop.field_196348_c, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)smallRedstoneBlockOff).addModel()).condition((Property)RSFlipFlop.field_196348_c, (Comparable[])new Boolean[]{false});
        for (Direction dir : RSFlipFlop.field_185512_D.func_177700_c()) {
            int yRot = (int)dir.func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)baseModel).rotationY(yRot).addModel()).condition((Property)RSFlipFlop.field_185512_D, (Comparable[])new Direction[]{dir});
        }
        this.simpleItem(b.getRegistryName().func_110623_a());
    }

    private void lamp(Block b) {
        String name = b.getRegistryName().func_110623_a();
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        ModelBuilder powered = ((BlockModelBuilder)this.models().withExistingParent("block/" + name + "_on", this.mcLoc("block/cube_all"))).texture("all", this.modLoc("block/" + name + "_on"));
        ModelBuilder unpowered = ((BlockModelBuilder)this.models().withExistingParent("block/" + name + "_off", this.mcLoc("block/cube_all"))).texture("all", this.modLoc("block/" + name + "_off"));
        builder.partialState().with((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)powered)});
        builder.partialState().with((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)unpowered)});
        this.simpleBlockItem(b, (ModelFile)unpowered);
    }

    private void rotarySwitch(Block b) {
        ModelFile.ExistingModelFile base = this.models().getExistingFile(this.modLoc("block/rotary_switch/rotary_switch_base"));
        ModelFile[] models = new ModelFile[16];
        for (int i = 0; i < models.length; ++i) {
            models[i] = this.models().getExistingFile(this.modLoc("block/rotary_switch/switch_" + i));
        }
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        for (AttachFace face : RotarySwitch.field_196366_M.func_177700_c()) {
            for (Direction dir : RotarySwitch.field_185512_D.func_177700_c()) {
                int yRot = (int)dir.func_185119_l();
                switch (face) {
                    case WALL: {
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir});
                        break;
                    }
                    case FLOOR: {
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationX(90).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir});
                        break;
                    }
                    case CEILING: {
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationX(270).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir});
                    }
                }
                Iterator iterator = RotarySwitch.POWER.func_177700_c().iterator();
                while (iterator.hasNext()) {
                    int power = (Integer)iterator.next();
                    switch (face) {
                        case WALL: {
                            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models[power]).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)RotarySwitch.POWER, (Comparable[])new Integer[]{power});
                            break;
                        }
                        case FLOOR: {
                            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models[power]).rotationX(90).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)RotarySwitch.POWER, (Comparable[])new Integer[]{power});
                            break;
                        }
                        case CEILING: {
                            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models[power]).rotationX(270).rotationY(yRot).addModel()).condition((Property)RotarySwitch.field_196366_M, (Comparable[])new AttachFace[]{face}).condition((Property)RotarySwitch.field_185512_D, (Comparable[])new Direction[]{dir}).condition((Property)RotarySwitch.POWER, (Comparable[])new Integer[]{power});
                        }
                    }
                }
            }
        }
        this.simpleItem(b.getRegistryName().func_110623_a());
    }

    private void repeater(Block block) {
        String name = block.getRegistryName().func_110623_a();
        String type = block == GatesBlocks.FAST_REPEATER.get() ? "fast" : (block == GatesBlocks.SLOW_REPEATER.get() ? "slow" : "");
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.forAllStates(blockState -> {
            String path = "block/repeater/" + type + "/repeater_" + blockState.func_177229_b((Property)CustomRepeater.field_176410_b) + "tick";
            if (((Boolean)blockState.func_177229_b((Property)CustomRepeater.field_196348_c)).booleanValue()) {
                path = path + "_on";
            }
            if (((Boolean)blockState.func_177229_b((Property)CustomRepeater.field_176411_a)).booleanValue()) {
                path = path + "_locked";
            }
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc(path));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)((Direction)blockState.func_177229_b((Property)CustomRepeater.field_185512_D)).func_185119_l()).build();
        });
        this.simpleItem(name);
    }

    private void waxedRedstone(Block b) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
        ModelFile.ExistingModelFile dotModel = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_dot"));
        ModelFile.ExistingModelFile lineModel = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_side"));
        ModelFile.ExistingModelFile lineModel4 = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_4side"));
        ModelFile.ExistingModelFile lineModel3 = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_3side"));
        ModelFile.ExistingModelFile lineModel2 = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_2side"));
        ModelFile.ExistingModelFile upModel = this.models().getExistingFile(this.modLoc("block/waxed_redstone/waxed_dust_side_up"));
        ModelBuilder line0 = ((BlockModelBuilder)this.models().withExistingParent("waxed_dust_line0", lineModel.getLocation())).texture("line", this.mcLoc("block/redstone_dust_line0"));
        ModelBuilder line1 = ((BlockModelBuilder)this.models().withExistingParent("waxed_dust_line1", lineModel.getLocation())).texture("line", this.mcLoc("block/redstone_dust_line1"));
        ModelBuilder up0 = ((BlockModelBuilder)this.models().withExistingParent("waxed_dust_line_up0", upModel.getLocation())).texture("line", this.mcLoc("block/redstone_dust_line0"));
        ModelBuilder up1 = ((BlockModelBuilder)this.models().withExistingParent("waxed_dust_line_up1", upModel.getLocation())).texture("line", this.mcLoc("block/redstone_dust_line1"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)dotModel).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)line0).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)line1).rotationY(90).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel4).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel2).rotationY(0).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP, RedstoneSide.SIDE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel2).rotationY(90).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel2).rotationY(180).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel2).rotationY(270).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP, RedstoneSide.SIDE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel3).rotationY(0).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP, RedstoneSide.SIDE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel3).rotationY(90).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel3).rotationY(180).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)lineModel3).rotationY(270).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP, RedstoneSide.SIDE}).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.NONE}).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP}).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.SIDE, RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)up0).rotationY(0).addModel()).condition((Property)WaxedRedstone.field_176348_a, (Comparable[])new RedstoneSide[]{RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)up1).rotationY(90).addModel()).condition((Property)WaxedRedstone.field_176347_b, (Comparable[])new RedstoneSide[]{RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)up0).rotationY(180).addModel()).condition((Property)WaxedRedstone.field_176349_M, (Comparable[])new RedstoneSide[]{RedstoneSide.UP});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)up1).rotationY(270).addModel()).condition((Property)WaxedRedstone.field_176350_N, (Comparable[])new RedstoneSide[]{RedstoneSide.UP});
        this.simpleItem(b.getRegistryName().func_110623_a());
    }

    private static /* synthetic */ ConfiguredModel[] lambda$detectorModel$0(ModelFile detector_inverted, ModelFile detector, BlockState blockState) {
        return ConfiguredModel.builder().modelFile((Boolean)blockState.func_177229_b((Property)CustomDetector.INVERTED) != false ? detector_inverted : detector).build();
    }
}

