/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.data_gen;

import com.github.se7_kn8.gates.Gates;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;

public class LootGenerator
implements IDataProvider {
    private final DataGenerator dataGenerator;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    public LootGenerator(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void add(ResourceLocation location, LootTable table) {
        this.tables.put(location, table);
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.dataGenerator.func_200391_b();
        ValidationTracker validator = new ValidationTracker(LootParameterSets.field_216266_g, resourceLocation -> null, this.tables::get);
        this.tables.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validator, (ResourceLocation)resourceLocation, (LootTable)lootTable));
        Multimap multimap = validator.func_227527_a_();
        if (!multimap.isEmpty()) {
            multimap.forEach((id, value) -> Gates.LOGGER.warn("Found validation problem in " + id + ": " + value));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        this.tables.forEach((resourceLocation, lootTable) -> {
            Path path1 = LootGenerator.getPath(outputFolder, resourceLocation);
            try {
                IDataProvider.func_218426_a((Gson)this.GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path1);
            }
            catch (IOException var6) {
                Gates.LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)var6);
            }
        });
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "GatesLootTable";
    }
}

