/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.mixin;

import com.github.se7_kn8.gates.api.IRedstoneWire;
import com.github.se7_kn8.gates.util.RedstoneHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedstoneWireBlock.class})
public abstract class RedstoneBlockMixin
implements IRedstoneWire {
    @Inject(at={@At(value="HEAD")}, method={"canConnectTo"}, cancellable=true, remap=false)
    private static void canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side, CallbackInfoReturnable<Boolean> info) {
        if (blockState.func_177230_c() instanceof IRedstoneWire) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getPower"}, cancellable=true)
    private void getPower(BlockState state, CallbackInfoReturnable<Integer> info) {
        if (state.func_177230_c() instanceof IRedstoneWire) {
            info.setReturnValue((Object)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"notifyWireNeighborsOfStateChange"}, cancellable=true)
    private void notifyWireNeighborsOfStateChange(World world, BlockPos pos, CallbackInfo info) {
        if (world.func_180495_p(pos).func_177230_c() instanceof IRedstoneWire) {
            world.func_195593_d(pos, (Block)((RedstoneWireBlock)this));
            for (Direction direction : Direction.values()) {
                world.func_195593_d(pos.func_177972_a(direction), (Block)((RedstoneWireBlock)this));
            }
            info.cancel();
        }
    }

    @Redirect(method={"getStrongestSignal"}, at=@At(value="FIELD", target="net/minecraft/block/RedstoneWireBlock.canProvidePower:Z"), require=2)
    private void redirectPowerWrite(RedstoneWireBlock owner, boolean value) {
        RedstoneHelper.canProvidePower = value;
    }

    @Redirect(method={"getWeakPower", "getStrongPower", "canProvidePower"}, at=@At(value="FIELD", target="net/minecraft/block/RedstoneWireBlock.canProvidePower:Z"), require=3)
    private boolean redirectPowerRead(RedstoneWireBlock owner) {
        return RedstoneHelper.canProvidePower;
    }
}

