/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.packages;

import com.github.se7_kn8.gates.GatesItems;
import com.github.se7_kn8.gates.packages.BasePacket;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdatePortableTransmitterPacket
implements BasePacket {
    private final int newFrequency;
    private final int hand;

    public UpdatePortableTransmitterPacket(int newFrequency, Hand hand) {
        this.newFrequency = newFrequency;
        this.hand = hand.ordinal();
    }

    public UpdatePortableTransmitterPacket(PacketBuffer buffer) {
        this.newFrequency = buffer.readInt();
        this.hand = buffer.readInt();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.newFrequency);
        buffer.writeInt(this.hand);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ((NetworkEvent.Context)ctx.get()).getSender().func_184586_b(Hand.values()[this.hand]);
            if (stack.func_77973_b() == GatesItems.PORTABLE_REDSTONE_TRANSMITTER.get()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74768_a("frequency", this.newFrequency);
            }
        });
    }
}

