/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.tile;

import com.github.se7_kn8.gates.GatesBlocks;
import com.github.se7_kn8.gates.api.CapabilityWirelessNode;
import com.github.se7_kn8.gates.api.IWirelessNode;
import com.github.se7_kn8.gates.container.FrequencyContainer;
import com.github.se7_kn8.gates.data.RedstoneReceiverWorldSavedData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ReceiverTileEntity
extends TileEntity
implements INamedContainerProvider {
    private String translationKey = "block.gates.receiver";
    private LazyOptional<IWirelessNode> wireless = LazyOptional.of(this::createWireless);

    public ReceiverTileEntity() {
        super((TileEntityType)GatesBlocks.RECEIVER_TILE_ENTITY_TYPE.get());
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    private IWirelessNode createWireless() {
        return new CapabilityWirelessNode.WirelessNodeImpl(1, IWirelessNode.Types.RECEIVER){

            @Override
            public void setFrequency(int newFrequency) {
                super.setFrequency(newFrequency);
                if (!((ReceiverTileEntity)ReceiverTileEntity.this).field_145850_b.field_72995_K) {
                    int newPower = RedstoneReceiverWorldSavedData.get((ServerWorld)ReceiverTileEntity.this.field_145850_b).getCurrentFrequencyValue(ReceiverTileEntity.this.field_145850_b, newFrequency);
                    this.setPower(newPower);
                }
                ReceiverTileEntity.this.func_70296_d();
            }

            @Override
            public void setPower(int newPower) {
                super.setPower(newPower);
                Block block = ReceiverTileEntity.this.field_145850_b.func_180495_p(ReceiverTileEntity.this.field_174879_c).func_177230_c();
                if (block instanceof IWirelessReceiver) {
                    ((IWirelessReceiver)block).onPowerChange(ReceiverTileEntity.this.field_145850_b, ReceiverTileEntity.this.field_174879_c, newPower);
                }
                ReceiverTileEntity.this.func_70296_d();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityWirelessNode.WIRELESS_NODE) {
            return this.wireless.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        CompoundNBT wirelessTag = compound.func_74775_l("wireless");
        this.wireless.ifPresent(c -> ((INBTSerializable)c).deserializeNBT((INBT)wirelessTag));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.wireless.ifPresent(c -> {
            CompoundNBT compoundNBT = (CompoundNBT)((INBTSerializable)c).serializeNBT();
            compound.func_218657_a("wireless", (INBT)compoundNBT);
        });
        return super.func_189515_b(compound);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.translationKey);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new FrequencyContainer(windowId, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public static interface IWirelessReceiver {
        public void onPowerChange(World var1, BlockPos var2, int var3);
    }
}

