/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.tile;

import com.github.se7_kn8.gates.Gates;
import com.github.se7_kn8.gates.GatesBlocks;
import com.github.se7_kn8.gates.block.redstone_clock.RedstoneClock;
import com.github.se7_kn8.gates.container.AdvancedRedstoneClockContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RedstoneClockTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int MIN_CLOCK_TIME;
    private static final int MAX_CLOCK_TIME;
    private static final int MIN_PULSE_LENGTH;
    private static final int MAX_PULSE_LENGTH;
    private int clockLength = 6;
    private int clockTime = 12;
    private int remainingTicks = 0;
    private int poweredTicks = 0;

    public RedstoneClockTileEntity() {
        super((TileEntityType)GatesBlocks.REDSTONE_CLOCK_TILE_ENTITY_TYPE.get());
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.remainingTicks = compound.func_74762_e("remaining");
        this.poweredTicks = compound.func_74762_e("powered");
        this.clockLength = compound.func_74762_e("clockLength");
        this.clockTime = compound.func_74762_e("clockTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("remaining", this.remainingTicks);
        compound.func_74768_a("powered", this.poweredTicks);
        compound.func_74768_a("clockLength", this.clockLength);
        compound.func_74768_a("clockTime", this.clockTime);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.remainingTicks <= 0) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneClock.POWERED, (Comparable)Boolean.valueOf(true)));
                this.poweredTicks = this.clockLength;
                this.remainingTicks = this.clockTime;
            } else {
                --this.remainingTicks;
            }
            if (this.poweredTicks <= 0) {
                if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RedstoneClock.POWERED)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneClock.POWERED, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                --this.poweredTicks;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.gates.advanced_redstone_clock");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new AdvancedRedstoneClockContainer(windowId, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public int getClockLength() {
        return this.clockLength;
    }

    public int getClockTime() {
        return this.clockTime;
    }

    public void setClockLength(int clockLength) {
        if (clockLength < MIN_PULSE_LENGTH) {
            clockLength = MIN_PULSE_LENGTH;
        } else if (clockLength > MAX_PULSE_LENGTH) {
            clockLength = MAX_PULSE_LENGTH;
        }
        this.clockLength = clockLength;
        this.checkLengthTimeRelation();
    }

    public void setClockTime(int clockTime) {
        if (clockTime < MIN_CLOCK_TIME) {
            clockTime = MIN_CLOCK_TIME;
        } else if (clockTime > MAX_CLOCK_TIME) {
            clockTime = MAX_CLOCK_TIME;
        }
        this.clockTime = clockTime;
        this.checkLengthTimeRelation();
    }

    public void resetClock() {
        this.poweredTicks = 0;
        this.remainingTicks = 0;
    }

    private void checkLengthTimeRelation() {
        if (this.clockLength >= this.clockTime) {
            this.clockLength = this.clockTime - 1;
        }
    }

    static {
        int minClockCycleTicks = (Integer)Gates.config.minClockTicks.get();
        int maxClockCycleTicks = (Integer)Gates.config.maxClockTicks.get();
        int minClockPulseTicks = (Integer)Gates.config.minClockPulseTicks.get();
        int maxClockPulseTicks = (Integer)Gates.config.maxClockPulseTicks.get();
        if (minClockCycleTicks > maxClockCycleTicks) {
            minClockCycleTicks = maxClockCycleTicks - 1;
        }
        if (minClockPulseTicks > maxClockPulseTicks) {
            minClockCycleTicks = maxClockPulseTicks - 1;
        }
        MIN_CLOCK_TIME = minClockCycleTicks;
        MAX_CLOCK_TIME = maxClockCycleTicks;
        MIN_PULSE_LENGTH = minClockPulseTicks;
        MAX_PULSE_LENGTH = maxClockPulseTicks;
    }
}

