/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.map_merging;

import com.polipo.map_merging.GiacomosMapMergingMod;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapMergingRecipe
extends SpecialRecipe {
    private static final Logger LOGGER = LogManager.getLogger();
    public static ItemStack result;

    public MapMergingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public static void initResult() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("giacomos_merging", true);
        result = new ItemStack((IItemProvider)Items.field_151098_aY, 1);
        result.func_77982_d(tag);
        result.func_200302_a((ITextComponent)new TranslationTextComponent("merged_map"));
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        byte scale = -1;
        int x = 0;
        int z = 0;
        RegistryKey dimension = null;
        int mapCount = 0;
        int emptyMapCount = 0;
        for (int index = 0; index < inv.func_70302_i_(); ++index) {
            ItemStack itemstack = inv.func_70301_a(index);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() == Items.field_151148_bJ) {
                ++emptyMapCount;
                continue;
            }
            if (itemstack.func_77973_b() == Items.field_151098_aY) {
                MapData mapdata = FilledMapItem.func_219994_a((ItemStack)itemstack, (World)worldIn);
                if (mapdata == null) {
                    return false;
                }
                if (scale == -1) {
                    scale = mapdata.field_76197_d;
                    x = mapdata.field_76201_a;
                    z = mapdata.field_76199_b;
                    dimension = mapdata.field_76200_c;
                } else if (scale != mapdata.field_76197_d || x != mapdata.field_76201_a || z != mapdata.field_76199_b || dimension != mapdata.field_76200_c) {
                    return false;
                }
                ++mapCount;
                continue;
            }
            return false;
        }
        return mapCount > 1 && emptyMapCount > 0;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        boolean done = false;
        NonNullList ret = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            if (stack.func_77973_b() == Items.field_151148_bJ && !done) {
                stack.func_190918_g(1);
                done = true;
            }
            ret.add((Object)stack);
        }
        return ret;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack result = new ItemStack((IItemProvider)Items.field_151098_aY, 1);
        ITextComponent name = null;
        int map = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int n;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151098_aY) continue;
            if (stack.func_82837_s()) {
                name = stack.func_200301_q();
            }
            CompoundNBT tag2 = stack.func_77978_p();
            LOGGER.info(((Object)((Object)this)).getClass().getName() + ".getCraftingResult tag2=" + tag2);
            if (tag2 == null || (n = tag2.func_74762_e("map")) <= map) continue;
            map = n;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("giacomos_merging", true);
        tag.func_74768_a("map", map + 1);
        result.func_77982_d(tag);
        if (name != null) {
            result.func_200302_a(name);
        }
        LOGGER.info(((Object)((Object)this)).getClass().getName() + ".getCraftingResult tag=" + result.func_77978_p());
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack func_77571_b() {
        return super.func_77571_b();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return super.func_192400_c();
    }

    public String func_193358_e() {
        return super.func_193358_e();
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return GiacomosMapMergingMod.CRAFTING_SPECIAL_MAPMERGING;
    }
}

