/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui;

import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.debug.Statistics;
import net.gliby.voicechat.client.gui.UIPosition;
import net.gliby.voicechat.client.gui.ValueFormat;
import net.gliby.voicechat.client.gui.options.GuiScreenOptionsWizard;
import net.gliby.voicechat.client.sound.ClientStream;
import net.gliby.voicechat.client.textures.IndependentGUITexture;
import net.gliby.voicechat.common.MathUtility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GuiInGameHandlerVoiceChat
extends Gui {
    private long lastFrame;
    private long lastFPS;
    private float fade = 0.0f;
    private final VoiceChatClient voiceChat;
    private ScaledResolution res;
    private Vector2f position;
    private final Minecraft mc;
    private UIPosition positionUI;

    public GuiInGameHandlerVoiceChat(VoiceChatClient voiceChat) {
        this.voiceChat = voiceChat;
        this.mc = Minecraft.func_71410_x();
    }

    public void calcDelta() {
        if (this.getTime() - this.lastFPS > 1000L) {
            this.lastFPS += 1000L;
        }
    }

    public int getDelta() {
        long time = this.getTime();
        int delta = (int)(time - this.lastFrame);
        this.lastFrame = time;
        return delta;
    }

    private Vector2f getPosition(int width, int height, UIPosition uiPositionSpeak) {
        return uiPositionSpeak.type == 0 ? new Vector2f(uiPositionSpeak.x * (float)width, uiPositionSpeak.y * (float)height) : new Vector2f(uiPositionSpeak.x, uiPositionSpeak.y);
    }

    public long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Text text) {
        if (text.type == RenderGameOverlayEvent.ElementType.DEBUG && VoiceChat.getProxyInstance().getSettings().isDebug()) {
            VoiceChat.getProxyInstance();
            Statistics stats = VoiceChatClient.getStatistics();
            if (stats != null) {
                int settings = 1 | ValueFormat.PRECISION(2) | 0xC0;
                String encodedAvg = ValueFormat.format(stats.getEncodedAverageDataReceived(), settings);
                String decodedAvg = ValueFormat.format(stats.getDecodedAverageDataReceived(), settings);
                String encodedData = ValueFormat.format(stats.getEncodedDataReceived(), settings);
                String decodedData = ValueFormat.format(stats.getDecodedDataReceived(), settings);
                text.right.add("Voice Chat Debug Info");
                text.right.add("VC Data [ENC AVG]: " + encodedAvg + "");
                text.right.add("VC Data [DEC AVG]: " + decodedAvg + "");
                text.right.add("VC Data [ENC REC]: " + encodedData + "");
                text.right.add("VC Data [DEC REC]: " + decodedData + "");
            }
        }
    }

    @SubscribeEvent
    public void renderInGameGui(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            if (this.res == null) {
                this.getDelta();
                this.lastFPS = this.getTime();
                if (this.voiceChat.getSettings().isSetupNeeded()) {
                    this.mc.func_147108_a((GuiScreen)new GuiScreenOptionsWizard(this.voiceChat, null));
                }
            }
            this.res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int width = this.res.func_78326_a();
            int height = this.res.func_78328_b();
            int delta = this.getDelta();
            this.calcDelta();
            this.fade = !VoiceChat.getProxyInstance().isRecorderActive() ? (this.fade > 0.0f ? (this.fade -= 0.01f * (float)delta) : 0.0f) : (this.fade < 1.0f && VoiceChat.getProxyInstance().isRecorderActive() ? (this.fade += 0.01f * (float)delta) : 1.0f);
            if (this.fade != 0.0f) {
                this.positionUI = this.voiceChat.getSettings().getUIPositionSpeak();
                this.position = this.getPosition(width, height, this.positionUI);
                if (this.positionUI.scale != 0.0f) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fade * this.voiceChat.getSettings().getUIOpacity()));
                    IndependentGUITexture.TEXTURES.bindTexture(this.mc);
                    GL11.glTranslatef((float)(this.position.x + (float)this.positionUI.info.offsetX), (float)(this.position.y + (float)this.positionUI.info.offsetY), (float)0.0f);
                    GL11.glScalef((float)this.positionUI.scale, (float)this.positionUI.scale, (float)1.0f);
                    this.func_73729_b(0, 0, 0, 0, 54, 46);
                    switch ((int)((float)(Minecraft.func_71386_F() % 1000L) / 350.0f)) {
                        case 0: {
                            this.func_73729_b(12, -3, 0, 47, 22, 49);
                            break;
                        }
                        case 1: {
                            this.func_73729_b(31, -3, 23, 47, 14, 49);
                            break;
                        }
                        case 2: {
                            this.func_73729_b(40, -3, 38, 47, 16, 49);
                        }
                    }
                    this.mc.func_110434_K().func_110577_a(this.mc.field_71439_g.func_110306_p());
                    GL11.glTranslatef((float)0.0f, (float)14.0f, (float)0.0f);
                    GL11.glScalef((float)2.4f, (float)2.4f, (float)0.0f);
                    Gui.func_152125_a((int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_175148_a(EnumPlayerModelParts.HAT)) {
                        Gui.func_152125_a((int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
            if (!VoiceChatClient.getSoundManager().currentStreams.isEmpty() && this.voiceChat.getSettings().isVoicePlateAllowed()) {
                float scale = 0.0f;
                this.positionUI = this.voiceChat.getSettings().getUIPositionPlate();
                this.position = this.getPosition(width, height, this.positionUI);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                for (int i = 0; i < VoiceChatClient.getSoundManager().currentStreams.size(); ++i) {
                    ClientStream stream = VoiceChatClient.getSoundManager().currentStreams.get(i);
                    if (stream == null) continue;
                    String s = stream.player.entityName();
                    boolean playerExists = stream.player.getPlayer() != null;
                    int length = this.mc.field_71466_p.func_78256_a(s);
                    scale = 0.75f * this.positionUI.scale;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(this.position.x + (float)this.positionUI.info.offsetX), (float)(this.position.y + (float)this.positionUI.info.offsetY + (float)(i * 23) * scale), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.voiceChat.getSettings().getUIOpacity());
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
                    IndependentGUITexture.TEXTURES.bindTexture(this.mc);
                    this.func_73729_b(0, 0, 56, stream.special * 22, 109, 22);
                    GL11.glPushMatrix();
                    scale = MathUtility.clamp(50.5f / (float)length, 0.0f, 1.25f);
                    GL11.glTranslatef((float)(25.0f + scale / 2.0f), (float)(11.0f - (float)(this.mc.field_71466_p.field_78288_b - 1) * scale / 2.0f), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                    this.func_73731_b(this.mc.field_71466_p, s, 0, 0, -1);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    if (playerExists) {
                        IndependentGUITexture.bindPlayer(this.mc, stream.player.getPlayer());
                    } else {
                        IndependentGUITexture.bindDefaultPlayer(this.mc);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.voiceChat.getSettings().getUIOpacity());
                    GL11.glTranslatef((float)3.25f, (float)3.25f, (float)0.0f);
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
                    Gui.func_152125_a((int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_175148_a(EnumPlayerModelParts.HAT)) {
                        Gui.func_152125_a((int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                    }
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                }
                GL11.glDisable((int)3042);
            }
            if (VoiceChatClient.getSoundManager().currentStreams.isEmpty()) {
                VoiceChatClient.getSoundManager().volumeControlStop();
            } else if (this.voiceChat.getSettings().isVolumeControlled()) {
                VoiceChatClient.getSoundManager().volumeControlStart();
            }
        }
    }
}

