/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatState;
import net.infstudio.goki.api.stat.StatStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityStat {
    @CapabilityInject(value=StatStorage.class)
    public static Capability<StatStorage> STAT;

    private static CompoundNBT serializeNBT(StatStorage statStorage) {
        CompoundNBT compound = new CompoundNBT();
        statStorage.stateMap.forEach((stat, state) -> {
            CompoundNBT stateTag = new CompoundNBT();
            stateTag.func_74768_a("level", state.level);
            stateTag.func_74768_a("revertedLevel", state.revertedLevel);
            compound.func_218657_a(stat.getRegistryName().toString(), (INBT)stateTag);
        });
        return compound;
    }

    private static void deserializeNBT(@Nonnull StatStorage statStorage, INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)nbt;
            for (String stat : compound.func_150296_c()) {
                ResourceLocation statLocation = new ResourceLocation(stat);
                if (!StatBase.REGISTRY.containsKey(statLocation)) continue;
                CompoundNBT stateTag = compound.func_74775_l(stat);
                Stat statObject = (Stat)StatBase.REGISTRY.getValue(statLocation);
                statStorage.stateMap.put(statObject, new StatState(statObject, stateTag.func_74762_e("level"), stateTag.func_74762_e("revertedLevel")));
            }
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(StatStorage.class, (Capability.IStorage)new Capability.IStorage<StatStorage>(){

            public INBT writeNBT(Capability<StatStorage> capability, StatStorage instance, Direction side) {
                return CapabilityStat.serializeNBT(instance);
            }

            public void readNBT(Capability<StatStorage> capability, StatStorage instance, Direction side, INBT nbt) {
                CapabilityStat.deserializeNBT(instance, nbt);
            }
        }, StatStorage::new);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public StatStorage statStorage = new StatStorage();
        public final LazyOptional<StatStorage> storageProperty = LazyOptional.of(() -> this.statStorage);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == STAT) {
                return this.storageProperty;
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return CapabilityStat.serializeNBT(this.statStorage);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            CapabilityStat.deserializeNBT(this.statStorage, (INBT)nbt);
        }
    }
}

