/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.stat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Objects;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.common.config.Configurable;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.config.stats.StatConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;

public abstract class StatBase<T extends StatConfig>
extends ForgeRegistryEntry<Stat>
implements Stat,
Configurable<T> {
    public static final IForgeRegistry<Stat> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("gokistats", "stats")).setType(Stat.class).create();
    public static final ObjectList<StatBase<?>> stats = new ObjectArrayList(16);
    public static LazyOptional<Integer> totalStats = LazyOptional.of(() -> REGISTRY.getValues().size());
    public int imageID;
    public String key;
    public float costMultiplier = 1.0f;
    public float limitMultiplier = 1.0f;
    public float bonusMultiplier = 1.0f;
    private boolean enabled = true;
    private final int limit;
    public final T config;
    public final ForgeConfigSpec configSpec;

    public StatBase(int imgId, String key, int limit) {
        this.imageID = imgId;
        this.limit = limit;
        this.key = key;
        stats.add((Object)this);
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> this.createConfig((ForgeConfigSpec.Builder)builder));
        this.configSpec = (ForgeConfigSpec)specPair.getRight();
        this.config = (StatConfig)specPair.getLeft();
        this.setRegistryName("gokistats", key.toLowerCase());
        REGISTRY.register((IForgeRegistryEntry)this);
    }

    protected float getFinalBonus(float currentBonus) {
        return (float)((double)currentBonus * (Double)((StatConfig)this.config).bonusMultiplier.get() * (Double)GokiConfig.SERVER.globalBonusMultiplier.get());
    }

    @Override
    public T createConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Server configuration settings").push("stats." + this.key);
        return (T)new StatConfig(builder);
    }

    @Override
    public float getBonus(PlayerEntity player) {
        return this.getBonus(DataHelper.getPlayerStatLevel(player, this)) * this.bonusMultiplier;
    }

    @Override
    public float[] getDescriptionFormatArguments(PlayerEntity player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(player) * 100.0f, 1)};
    }

    @Override
    public int getCost(int level) {
        return (int)((Math.pow(level, 1.6) + 6.0 + (double)level) * (Double)((StatConfig)this.config).costMultiplier.get() * (Double)GokiConfig.SERVER.globalCostMultiplier.get());
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[1] instanceof ItemStack && obj[2] instanceof BlockPos && obj[3] instanceof World) {
            ItemStack stack = (ItemStack)obj[1];
            BlockPos pos = (BlockPos)obj[2];
            World world = (World)obj[3];
            return ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)stack);
        }
        return false;
    }

    @Override
    public int getLimit() {
        int limit = this.limit;
        if ((Integer)((StatConfig)this.config).maxLevel.get() > 0) {
            return (Integer)((StatConfig)this.config).maxLevel.get();
        }
        if ((Double)GokiConfig.SERVER.globalLimitMultiplier.get() <= 0.0) {
            return limit;
        }
        return (int)((double)limit * (Double)GokiConfig.SERVER.globalLimitMultiplier.get());
    }

    @Override
    public float getAppliedBonus(PlayerEntity player, Object object) {
        if (this.isEffectiveOn(object)) {
            return this.getBonus(player);
        }
        return 0.0f;
    }

    protected final int getPlayerStatLevel(PlayerEntity player) {
        return DataHelper.getPlayerStatLevel(player, this);
    }

    @Override
    public final boolean isEffectiveOn(ItemStack stack, BlockPos pos, World world) {
        if (ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)stack)) {
            return true;
        }
        return this.isEffectiveOn(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("skill.gokistats." + this.key), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedDescription(PlayerEntity player) {
        return I18n.func_135052_a((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[]{Float.valueOf(this.getDescriptionFormatArguments(player)[0])});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatBase)) {
            return false;
        }
        StatBase statBase = (StatBase)o;
        return Objects.equals(this.getRegistryName(), statBase.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    @Override
    public boolean isEnabled() {
        return this.getLimit() != 0 && this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

