/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStats;
import net.infstudio.goki.common.utils.DataHelper;
import net.infstudio.goki.common.utils.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiStatButton
extends Button {
    public StatBase<?> stat;
    public PlayerEntity player;
    public static final int INACTIVE_X = 0;
    public static final int ACTIVATED_X = 24;
    public static final int DISABLED_X = 48;
    public static final int MAXIMUM_X = 72;
    public final int id;
    private final Minecraft mc = Minecraft.func_71410_x();

    public GuiStatButton(int id, int x, int y, int width, int height, StatBase<?> stat, PlayerEntity player, Button.IPressable onPress) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, onPress);
        this.id = id;
        this.stat = stat;
        this.player = player;
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            int iconY = 24 * (this.stat.imageID % 10);
            int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
            int cost = this.stat.getCost(level);
            int playerXP = DataHelper.getXPTotal(this.player);
            FontRenderer fontrenderer = this.mc.field_71466_p;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230692_n_ = this.isUnderMouse(mouseX, mouseY);
            int iconX = 0;
            if (this.func_230449_g_()) {
                iconX = 24;
            }
            if (playerXP < cost) {
                iconX = 0;
            }
            if (level >= this.stat.getLimit()) {
                iconX = 72;
            }
            if (Screen.func_231172_r_()) {
                iconX = DataHelper.canPlayerRevertStat(this.player, this.stat) ? 24 : 48;
            }
            if (!this.stat.isEnabled()) {
                iconX = 48;
            }
            String message = level + "";
            if (!this.stat.isEnabled()) {
                iconX = 48;
                message = "X";
            }
            int messageColor = 0xFFFFFF;
            if (level >= this.stat.getLimit()) {
                message = "*" + level + "*";
                messageColor = 0xFFCC00;
            }
            iconX += this.stat.imageID % 20 / 10 * 24 * 4;
            if (this.stat.imageID >= 20) {
                this.mc.func_110434_K().func_110577_a(Reference.RPG_ICON_2_TEXTURE_LOCATION);
            } else {
                this.mc.func_110434_K().func_110577_a(Reference.RPG_ICON_TEXTURE_LOCATION);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
            GL11.glScalef((float)GuiStats.SCALE, (float)GuiStats.SCALE, (float)0.0f);
            this.func_238474_b_(stack, 0, 0, iconX, iconY, this.field_230688_j_, this.field_230689_k_);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
            GuiStatButton.func_238471_a_((MatrixStack)stack, (FontRenderer)fontrenderer, (String)message, (int)((int)((float)(this.field_230688_j_ / 2) * GuiStats.SCALE)), (int)((int)((float)this.field_230689_k_ * GuiStats.SCALE) + 2), (int)messageColor);
            GL11.glPopMatrix();
        }
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && (float)mouseX < (float)this.field_230690_l_ + (float)this.field_230688_j_ * GuiStats.SCALE && (float)mouseY < (float)this.field_230691_m_ + (float)this.field_230689_k_ * GuiStats.SCALE;
    }

    public void func_230982_a_(double p_onClick_1_, double p_onClick_3_) {
        super.func_230982_a_(p_onClick_1_, p_onClick_3_);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int mouseX, int mouseY) {
        return this.field_230693_o_ && this.field_230694_p_ && mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && (float)mouseX < (float)this.field_230690_l_ + (float)this.field_230688_j_ * GuiStats.SCALE && (float)mouseY < (float)this.field_230691_m_ + (float)this.field_230689_k_ * GuiStats.SCALE;
    }

    public String getHoverMessage(int which) {
        if (which == 0) {
            return this.stat.getLocalizedName() + " L" + DataHelper.getPlayerStatLevel(this.player, this.stat);
        }
        return this.stat.getLocalizedDescription(this.player);
    }
}

