/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStatButton;
import net.infstudio.goki.client.gui.GuiStatTooltip;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.C2SRequestStatSync;
import net.infstudio.goki.common.network.message.C2SStatSync;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiStats
extends Screen {
    public static final int STATUS_BUTTON_WIDTH = 24;
    public static final int STATUS_BUTTON_HEIGHT = 24;
    public static final int IMAGE_ROWS = 10;
    private static final int[] COLUMNS = new int[]{4, 4, 5, 4, 5, 4};
    public static float SCALE = 1.0f;
    private final PlayerEntity player;
    private final FontRenderer fontRenderer;
    private int currentColumn;
    private int currentRow;
    private GuiStatTooltip toolTip;

    public GuiStats() {
        super((ITextComponent)new StringTextComponent(""));
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.currentColumn = 0;
        this.currentRow = 0;
        this.toolTip = null;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float par3) {
        int toolTipX = 0;
        int toolTipY = 0;
        this.toolTip = null;
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, par3);
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            GuiStatButton button;
            if (!(this.field_230710_m_.get(i) instanceof GuiStatButton) || !(button = (GuiStatButton)((Object)this.field_230710_m_.get(i))).isUnderMouse(mouseX, mouseY)) continue;
            this.toolTip = new GuiStatTooltip((StatBase)StatBase.stats.get(i), this.player);
            toolTipX = button.field_230690_l_ + 12;
            toolTipY = button.field_230691_m_ - 1;
            break;
        }
        GuiStats.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.fontRenderer, (String)I18n.func_135052_a((String)"ui.currentxp", (Object[])new Object[]{DataHelper.getXPTotal(this.player)}), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 16), (int)-1);
        if (this.toolTip != null) {
            this.toolTip.draw(matrixStack, toolTipX, toolTipY, 0);
        }
    }

    public void func_231160_c_() {
        GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SRequestStatSync());
        for (int stat = 0; stat < (Integer)StatBase.totalStats.orElse((Object)0); ++stat) {
            Vector2f pos = this.getButton(stat);
            this.field_230710_m_.add(new GuiStatButton(stat, (int)pos.field_189982_i, (int)pos.field_189983_j, 24, 24, (StatBase)StatBase.stats.get(stat), this.player, this::actionPerformed));
            ++this.currentColumn;
            if (this.currentColumn >= COLUMNS[this.currentRow]) {
                ++this.currentRow;
                this.currentColumn = 0;
            }
            if (this.currentRow < COLUMNS.length) continue;
            this.currentRow = COLUMNS.length - 1;
        }
        this.field_230705_e_.addAll(this.field_230710_m_);
    }

    private Vector2f getButton(int n) {
        int columns = COLUMNS[this.currentRow];
        int x = n % columns;
        int y = this.currentRow;
        int rows = COLUMNS.length;
        float width = (float)(columns * 32) * SCALE;
        float height = (float)(rows * 36) * SCALE;
        return new Vector2f(width / (float)columns * (float)x + ((float)this.field_230708_k_ - width + 8.0f) / 2.0f, height / (float)rows * (float)y + ((float)this.field_230709_l_ - height + 12.0f) / 2.0f);
    }

    protected void actionPerformed(Button btn) {
        if (!(btn instanceof GuiStatButton)) {
            return;
        }
        GuiStatButton button = (GuiStatButton)btn;
        if (button.id >= 0 && button.id <= (Integer)StatBase.totalStats.orElse((Object)0)) {
            GuiStatButton statButton = button;
            if (!GuiStats.func_231172_r_()) {
                GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SStatSync(StatBase.stats.indexOf(statButton.stat), 1));
            } else {
                GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SStatSync(StatBase.stats.indexOf(statButton.stat), -1));
            }
        }
    }
}

