/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.network.handler;

import java.util.function.Supplier;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.network.message.S2CStatSync;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncClientHandler {
    public static void acceptSync(S2CStatSync message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncClientHandler.acceptSyncInternal(message)));
        ctx.setPacketHandled(true);
    }

    public static void acceptSyncAll(S2CSyncAll message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncClientHandler.acceptSyncAllInternal(message)));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptSyncInternal(S2CStatSync message) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        StatBase stat = (StatBase)StatBase.stats.get(message.stat);
        if (stat == Stats.MAX_HEALTH) {
            player.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(20 + message.amount));
        }
        DataHelper.setPlayerRevertStatLevel((PlayerEntity)player, stat, message.reverted);
        DataHelper.setPlayerStatLevel((PlayerEntity)player, stat, message.amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptSyncAllInternal(S2CSyncAll message) {
        int i;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (i = 0; i < message.statLevels.length; ++i) {
            DataHelper.setPlayerStatLevel((PlayerEntity)player, (Stat)StatBase.stats.get(i), message.statLevels[i]);
        }
        for (i = 0; i < message.revertedStatLevels.length; ++i) {
            DataHelper.setPlayerRevertStatLevel((PlayerEntity)player, (Stat)StatBase.stats.get(i), message.revertedStatLevels[i]);
        }
        player.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(20 + DataHelper.getPlayerStatLevel((PlayerEntity)player, Stats.MAX_HEALTH)));
    }
}

