/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatSpecial;
import net.infstudio.goki.api.stat.StatStorage;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="gokistats")
@Mod.EventBusSubscriber(modid="gokistats")
public class CommonHandler {
    @SubscribeEvent
    public static void injectCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("gokistats", "stat_storage"), (ICapabilityProvider)new CapabilityStat.Provider());
        }
    }

    @SubscribeEvent
    public static void playerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            int featherFallLevel = DataHelper.getPlayerStatLevel(player, Stats.STAT_FEATHER_FALL);
            if ((double)event.getDistance() < 3.0 + (double)featherFallLevel * 0.1) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getOriginal().getCapability(CapabilityStat.STAT).isPresent() && event.getEntity().getCapability(CapabilityStat.STAT).isPresent()) {
            ((StatStorage)event.getEntity().getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap = ((StatStorage)event.getOriginal().getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap;
        }
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.func_201670_d()) {
            if (((Boolean)GokiConfig.SERVER.loseStatsOnDeath.get()).booleanValue()) {
                for (int stat = 0; stat < (Integer)StatBase.totalStats.orElse((Object)0); ++stat) {
                    DataHelper.multiplyPlayerStatLevel(player, (Stat)StatBase.stats.get(stat), level -> level - (int)((Double)GokiConfig.SERVER.loseStatsMultiplier.get() * (double)level));
                }
            }
            GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new S2CSyncAll(player));
        }
    }

    @SubscribeEvent
    public static void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getPlayer().func_184614_ca();
        PlayerEntity player = event.getPlayer();
        float multiplier = 1.0f;
        if (Stats.MINING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.MINING.getBonus(player);
        }
        if (Stats.DIGGING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.DIGGING.getBonus(player);
        }
        if (Stats.CHOPPING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.CHOPPING.getBonus(player);
        }
        if (Stats.TRIMMING.isEffectiveOn(heldItem, event.getPos(), player.field_70170_p)) {
            multiplier += Stats.TRIMMING.getBonus(player);
        }
        event.setNewSpeed(event.getOriginalSpeed() * multiplier);
    }

    @SubscribeEvent
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_70051_ag()) {
            player.func_213317_d(player.func_213322_ci().func_216372_d(1.0 + (double)Stats.LEAPER_V.getBonus(player), 1.0 + (double)Stats.LEAPER_H.getBonus(player), 1.0 + (double)Stats.LEAPER_H.getBonus(player)));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        Entity src;
        DamageSource source = event.getSource();
        LivingEntity victim = event.getEntityLiving();
        if (victim instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)victim;
            if (!source.func_76347_k() && !source.func_151517_h() && player.field_70170_p.field_73012_v.nextFloat() >= 1.0f - Stats.ROLL.getBonus(player)) {
                event.setCanceled(true);
                player.func_195064_c(new EffectInstance(Effects.field_76420_g, 20, 2));
                victim.func_184211_a("knockback");
                return;
            }
            float damageMultiplier = 1.0f - (Stats.PROTECTION.getAppliedBonus(player, source) + Stats.TOUGH_SKIN.getAppliedBonus(player, source) + Stats.STAT_FEATHER_FALL.getAppliedBonus(player, source) + Stats.TEMPERING.getAppliedBonus(player, source));
            event.setAmount(event.getAmount() * damageMultiplier);
        }
        if ((src = source.func_76364_f()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)src;
            ItemStack heldItem = player.func_184614_ca();
            float damage = event.getAmount();
            float bonus = 0.0f;
            if (!heldItem.func_190926_b()) {
                if (Stats.SWORDSMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round(damage * Stats.SWORDSMANSHIP.getAppliedBonus(player, heldItem));
                } else if (Stats.BOWMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round(damage * Stats.BOWMANSHIP.getAppliedBonus(player, heldItem));
                } else if (!DataHelper.hasDamageModifier(heldItem)) {
                    bonus = Math.round(damage + Stats.PUGILISM.getBonus(player));
                }
            } else {
                bonus = Math.round(damage + Stats.PUGILISM.getBonus(player));
            }
            event.setAmount(bonus + damage);
            if (Stats.REAPER.isEffectiveOn(victim)) {
                float reap = Stats.REAPER.getBonus(player);
                float reapBonus = 0.0f;
                if (Stats.STEALTH.isEffectiveOn(player)) {
                    reapBonus = reap * ((StatSpecial)((Object)Stats.STEALTH)).getSecondaryBonus(player) / 100.0f;
                }
                float reapChance = reap + reapBonus;
                if (player.func_70681_au().nextFloat() <= reapChance) {
                    player.func_71009_b((Entity)victim);
                    player.field_70170_p.func_184133_a(player, event.getEntity().func_233580_cy_(), GokiSounds.REAPER, SoundCategory.MASTER, 1.0f, 1.0f);
                    event.setAmount(100000.0f);
                }
            }
        }
    }
}

