/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.stat.tool.StatMiningMagician;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class GokiLootModifier
extends LootModifier {
    protected GokiLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!(context.func_216033_a(LootParameters.field_216287_g) && context.func_216033_a(LootParameters.field_216281_a) && context.func_216033_a(LootParameters.field_237457_g_))) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(entity instanceof PlayerEntity)) {
            return generatedLoot;
        }
        Block block = ((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c();
        PlayerEntity player = (PlayerEntity)entity;
        if (DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER) > 0) {
            boolean treasureFound = false;
            Random random = player.func_70681_au();
            List<ItemStack> items = Stats.TREASURE_FINDER.getApplicableItemStackList(block, DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            IntList chances = Stats.TREASURE_FINDER.getApplicableChanceList(block, DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            for (int i = 0; i < items.size(); ++i) {
                int roll = random.nextInt(10000);
                if (roll > chances.getInt(i)) continue;
                if (items.get(i) != null) {
                    generatedLoot.add(items.get(i));
                    treasureFound = true;
                    continue;
                }
                System.out.println("Tried to add an item from Treasure Finder, but it failed!");
            }
            if (treasureFound) {
                player.field_70170_p.func_184133_a(player, new BlockPos((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)), GokiSounds.TREASURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.MINING_MAGICIAN) > 0) {
            boolean magicHappened = false;
            if (Stats.MINING_MAGICIAN.isEffectiveOn(block)) {
                block1: for (int i = 0; i < generatedLoot.size(); ++i) {
                    if (!(player.func_70681_au().nextDouble() * 100.0 <= (double)Stats.MINING_MAGICIAN.getBonus(player))) continue;
                    ItemStack item = generatedLoot.get(i);
                    if (item.func_77973_b() instanceof BlockItem && item.func_77973_b().getRegistryName().equals((Object)block.getRegistryName())) {
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.blockEntries.size());
                        ItemStack stack = new ItemStack((IItemProvider)StatMiningMagician.blockEntries.get(randomEntry), 1);
                        stack.func_190920_e(generatedLoot.get(i).func_190916_E());
                        generatedLoot.add(stack);
                        magicHappened = true;
                        continue;
                    }
                    for (int j = 0; j < StatMiningMagician.itemEntries.size(); ++j) {
                        if (item.func_77973_b() != StatMiningMagician.itemEntries.get(j)) continue;
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.itemEntries.size());
                        ItemStack stack = new ItemStack((IItemProvider)StatMiningMagician.itemEntries.get(randomEntry), 1);
                        stack.func_190920_e(generatedLoot.get(i).func_190916_E());
                        generatedLoot.add(stack);
                        magicHappened = true;
                        continue block1;
                    }
                }
                if (magicHappened) {
                    player.field_70170_p.func_184133_a(player, new BlockPos((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)), GokiSounds.MAGICIAN, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GokiLootModifier> {
        public GokiLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new GokiLootModifier(conditionsIn);
        }

        public JsonObject write(GokiLootModifier instance) {
            return new JsonObject();
        }
    }
}

