/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.handlers.SyncEventHandler;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="gokistats")
public class TickHandler {
    public static final UUID knockbackResistanceID = UUID.randomUUID();
    public static final UUID stealthSpeedID = UUID.randomUUID();
    public static final UUID swimSpeedID = UUID.randomUUID();
    public static AtomicInteger tickTimer = new AtomicInteger();

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntity player = event.player;
            TickHandler.handleTaskPlayerAPI(player);
            ModifiableAttributeInstance attributeInstance = player.func_110148_a(Attributes.field_233821_d_);
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(stealthSpeedID, "SneakSpeed", (double)(Stats.STEALTH.getBonus(player) / 100.0f), AttributeModifier.Operation.func_220372_a((int)1));
            if (player.func_213453_ef()) {
                if (attributeInstance.func_111127_a(stealthSpeedID) == null) {
                    attributeInstance.func_233767_b_(modifier);
                }
            } else if (attributeInstance.func_111127_a(stealthSpeedID) != null) {
                attributeInstance.func_111124_b(modifier);
            }
            if ((attributeInstance = player.func_110148_a(Attributes.field_233820_c_)) == null) {
                return;
            }
            modifier = new AttributeModifier(knockbackResistanceID, "KnockbackResistance", (double)Stats.STEADY_GUARD.getBonus(player), AttributeModifier.Operation.func_220372_a((int)0));
            if (player.func_184585_cz()) {
                if (attributeInstance.func_111127_a(knockbackResistanceID) == null) {
                    attributeInstance.func_233767_b_(modifier);
                }
            } else if (attributeInstance.func_111127_a(knockbackResistanceID) != null) {
                attributeInstance.func_111124_b(modifier);
            }
            TickHandler.handleFurnace(player);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && (Integer)GokiConfig.SERVER.syncTicks.get() > 0) {
            if (tickTimer.get() == ((Integer)GokiConfig.SERVER.syncTicks.get()).intValue()) {
                tickTimer.lazySet(0);
                for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                    SyncEventHandler.syncPlayerData((PlayerEntity)player);
                }
            } else {
                tickTimer.getAndIncrement();
            }
        }
    }

    public static boolean isJumping(LivingEntity livingBase) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingBase, (String)"field_70703_bu");
    }

    private static void handleTaskPlayerAPI(PlayerEntity player) {
        float multiplier;
        if ((!player.func_175144_cb() || player.canRiderInteract()) && player.func_203007_ba()) {
            multiplier = Math.max(0.0f, Stats.SWIMMING.getBonus(player));
            if (!TickHandler.isJumping((LivingEntity)player) && multiplier > 0.0f) {
                double d0 = player.func_226278_cu_();
                float f1 = 0.8f;
                float f2 = 0.02f;
                if (multiplier > 0.0f) {
                    f1 += (0.54600006f - f1) * multiplier;
                    f2 += (player.func_70689_ay() - f2) * multiplier;
                }
                player.func_213309_a(f2, player.func_213322_ci());
                player.func_213315_a(MoverType.SELF, player.func_213322_ci());
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)f1, (double)0.8f, (double)f1));
                if (!player.func_189652_ae()) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.02, 0.0));
                }
                Vector3d vector3d = player.func_213322_ci().func_72441_c(0.0, (double)0.6f - player.func_226278_cu_() + d0, 0.0);
            }
        }
        if (player.func_70617_f_() && !player.func_225608_bj_()) {
            multiplier = Stats.CLIMBING.getBonus(player);
            player.func_213315_a(MoverType.SELF, player.func_213322_ci().func_216372_d(1.0, (double)multiplier, 1.0));
        }
    }

    private static void handleFurnace(PlayerEntity player) {
        int level = DataHelper.getPlayerStatLevel(player, Stats.FURNACE_FINESSE);
        if (level > 0 && !player.field_70170_p.func_201670_d()) {
            ArrayList<FurnaceTileEntity> furnacesAroundPlayer = new ArrayList<FurnaceTileEntity>();
            for (TileEntity listEntity : player.field_70170_p.field_175730_i) {
                if (listEntity == null) continue;
                BlockPos pos = listEntity.func_174877_v();
                if (!(listEntity instanceof FurnaceTileEntity) || !(player.func_195048_a(Vector3d.func_237489_a_((Vector3i)pos)) < 4.0)) continue;
                furnacesAroundPlayer.add((FurnaceTileEntity)listEntity);
            }
            for (FurnaceTileEntity furnace : furnacesAroundPlayer) {
                int i = 0;
                while ((float)i < Stats.FURNACE_FINESSE.getBonus(player)) {
                    furnace.func_73660_a();
                    ++i;
                }
            }
            furnacesAroundPlayer.clear();
        }
    }
}

