/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.network.message;

import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.network.message.IMessage;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class S2CSyncAll
implements IMessage {
    public int[] statLevels = new int[0];
    public int[] revertedStatLevels = new int[0];

    public S2CSyncAll() {
    }

    public S2CSyncAll(PlayerEntity player) {
        this.statLevels = new int[StatBase.stats.size()];
        this.revertedStatLevels = new int[StatBase.stats.size()];
        for (int i = 0; i < this.statLevels.length; ++i) {
            if (StatBase.stats.get(i) == null) continue;
            this.statLevels[i] = DataHelper.getPlayerStatLevel(player, (Stat)StatBase.stats.get(i));
            this.revertedStatLevels[i] = DataHelper.getPlayerRevertStatLevel(player, (Stat)StatBase.stats.get(i));
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        int i;
        this.statLevels = new int[buf.readInt()];
        this.revertedStatLevels = new int[buf.readInt()];
        for (i = 0; i < this.statLevels.length; ++i) {
            this.statLevels[i] = buf.readInt();
        }
        for (i = 0; i < this.revertedStatLevels.length; ++i) {
            this.revertedStatLevels[i] = buf.readInt();
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.statLevels.length);
        buf.writeInt(this.revertedStatLevels.length);
        for (int statLevel : this.statLevels) {
            buf.writeInt(statLevel);
        }
        for (int revertedStatLevel : this.revertedStatLevels) {
            buf.writeInt(revertedStatLevel);
        }
    }
}

