/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.utils;

import java.util.Collection;
import java.util.function.IntFunction;
import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.common.config.GokiConfig;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;

public class DataHelper {
    public static boolean canPlayerRevertStat(PlayerEntity player, Stat stat) {
        return (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() == -1 || (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() >= 0 && DataHelper.getPlayerRevertStatLevel(player, stat) < (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() && DataHelper.getPlayerStatLevel(player, stat) > 0;
    }

    public static int getPlayerRevertStatLevel(PlayerEntity player, Stat stat) {
        return player.getCapability(CapabilityStat.STAT).map(storage -> storage.stateMap.get((Object)stat).revertedLevel).orElse(0);
    }

    public static void setPlayerRevertStatLevel(PlayerEntity player, Stat stat, int level) {
        player.getCapability(CapabilityStat.STAT).ifPresent(storage -> {
            storage.stateMap.get((Object)stat).revertedLevel = level;
        });
    }

    public static int getPlayerStatLevel(PlayerEntity player, Stat stat) {
        return player.getCapability(CapabilityStat.STAT).map(storage -> storage.stateMap.get((Object)stat).level).orElse(0);
    }

    public static void setPlayerStatLevel(PlayerEntity player, Stat stat, int level) {
        player.getCapability(CapabilityStat.STAT).ifPresent(storage -> {
            storage.stateMap.get((Object)stat).level = level;
        });
    }

    public static void multiplyPlayerStatLevel(PlayerEntity player, Stat stat, IntFunction<Integer> multiplier) {
        DataHelper.setPlayerStatLevel(player, stat, multiplier.apply(DataHelper.getPlayerStatLevel(player, stat)));
    }

    public static float trimDecimals(float in, int decimals) {
        float f = (float)((double)in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static int getXPTotal(PlayerEntity player) {
        int level = player.field_71068_ca;
        int offset = player.field_71067_cb;
        if (level <= 16) {
            return level * level + 6 * level + offset;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level) + 360 + offset;
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level) + 2220 + offset;
    }

    public static boolean hasDamageModifier(ItemStack stack) {
        Collection modifiers = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack).get((Object)Attributes.field_233823_f_);
        return modifiers != null && !modifiers.isEmpty();
    }

    public static float getDamageDealt(PlayerEntity player, Entity target, DamageSource source) {
        float damage = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof LivingEntity;
        ItemStack stack = player.func_184614_ca();
        if (targetIsLiving) {
            bonusDamage += EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)target).func_70668_bt());
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean critical;
            boolean bl = critical = player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && player.func_184187_bx() == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(LivingEntity entity) {
        float resistance = 3.0f;
        EffectInstance potionEffect = entity.func_70660_b(Effects.field_76430_j);
        float bonus = potionEffect != null ? (float)(potionEffect.func_76458_c() + 1) : 0.0f;
        return resistance + bonus;
    }
}

