/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatState;
import net.infstudio.goki.api.stat.StatStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gokistats")
public class CapabilityStat {
    public static Capability<StatStorage> STAT = CapabilityManager.get((CapabilityToken)new CapabilityToken<StatStorage>(){});

    private static CompoundTag serializeNBT(StatStorage statStorage) {
        CompoundTag compound = new CompoundTag();
        statStorage.stateMap.forEach((stat, state) -> {
            CompoundTag stateTag = new CompoundTag();
            stateTag.m_128405_("level", state.level);
            stateTag.m_128405_("revertedLevel", state.revertedLevel);
            compound.m_128365_(stat.getRegistryName().toString(), (Tag)stateTag);
        });
        return compound;
    }

    private static void deserializeNBT(@Nonnull StatStorage statStorage, Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            for (String stat : compound.m_128431_()) {
                ResourceLocation statLocation = new ResourceLocation(stat);
                if (!StatBase.REGISTRY.containsKey(statLocation)) continue;
                CompoundTag stateTag = compound.m_128469_(stat);
                Stat statObject = (Stat)StatBase.REGISTRY.getValue(statLocation);
                statStorage.stateMap.put(statObject, new StatState(statObject, stateTag.m_128451_("level"), stateTag.m_128451_("revertedLevel")));
            }
        }
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(StatStorage.class);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public StatStorage statStorage = new StatStorage();
        public final LazyOptional<StatStorage> storageProperty = LazyOptional.of(() -> this.statStorage);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == STAT) {
                return this.storageProperty;
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return CapabilityStat.serializeNBT(this.statStorage);
        }

        public void deserializeNBT(CompoundTag nbt) {
            CapabilityStat.deserializeNBT(this.statStorage, (Tag)nbt);
        }
    }
}

