/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.stat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Objects;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.common.config.Configurable;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.config.stats.StatConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;

public abstract class StatBase<T extends StatConfig>
extends ForgeRegistryEntry<Stat>
implements Stat,
Configurable<T> {
    public static final IForgeRegistry<Stat> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("gokistats", "stats")).setType(Stat.class).create();
    public static final ObjectList<StatBase<?>> stats = new ObjectArrayList(16);
    public static LazyOptional<Integer> totalStats = LazyOptional.of(() -> REGISTRY.getValues().size());
    public int imageID;
    public String key;
    private boolean enabled = true;
    private final int limit;
    public final T config;
    public final ForgeConfigSpec configSpec;

    public StatBase(int imgId, String key, int limit) {
        this.imageID = imgId;
        this.limit = limit;
        this.key = key;
        stats.add((Object)this);
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> this.createConfig((ForgeConfigSpec.Builder)builder));
        this.configSpec = (ForgeConfigSpec)specPair.getRight();
        this.config = (StatConfig)specPair.getLeft();
        this.setRegistryName("gokistats", key.toLowerCase());
        REGISTRY.register((IForgeRegistryEntry)this);
    }

    protected float getFinalBonus(float currentBonus) {
        return (float)((double)currentBonus * (Double)((StatConfig)this.config).bonusMultiplier.get() * (Double)GokiConfig.SERVER.globalBonusMultiplier.get());
    }

    @Override
    public T createConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Server configuration settings").push("stats." + this.key);
        return (T)new StatConfig(builder);
    }

    @Override
    public double getBonus(Player player) {
        return this.getBonus(DataHelper.getPlayerStatLevel(player, this)) * this.getBonusMultiplier();
    }

    @Override
    public double[] getDescriptionFormatArguments(Player player) {
        return new double[]{DataHelper.trimDecimals(this.getBonus(player) * 100.0, 1)};
    }

    @Override
    public int getCost(int level) {
        return (int)((Math.pow(level, 1.6) + 6.0 + (double)level) * (Double)((StatConfig)this.config).costMultiplier.get() * (Double)GokiConfig.SERVER.globalCostMultiplier.get());
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        Object object = obj[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            object = obj[1];
            if (object instanceof BlockPos) {
                BlockPos pos = (BlockPos)object;
                object = obj[2];
                if (object instanceof Level) {
                    Level world = (Level)object;
                    return stack.m_41735_(world.m_8055_(pos));
                }
            }
        }
        return false;
    }

    @Override
    public int getLimit() {
        int limit = this.limit;
        if ((Integer)((StatConfig)this.config).maxLevel.get() > 0) {
            return (Integer)((StatConfig)this.config).maxLevel.get();
        }
        if ((Double)GokiConfig.SERVER.globalLimitMultiplier.get() <= 0.0) {
            return limit;
        }
        return (int)((double)limit * (Double)GokiConfig.SERVER.globalLimitMultiplier.get());
    }

    @Override
    public double getAppliedBonus(Player player, Object object) {
        if (this.isEffectiveOn(object)) {
            return this.getBonus(player);
        }
        return 0.0;
    }

    protected final int getPlayerStatLevel(Player player) {
        return DataHelper.getPlayerStatLevel(player, this);
    }

    @Override
    public final boolean isEffectiveOn(ItemStack stack, BlockPos pos, Level world) {
        if (stack.m_41735_(world.m_8055_(pos))) {
            return true;
        }
        return this.isEffectiveOn(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedName() {
        return I18n.m_118938_((String)("skill.gokistats." + this.key), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedDescription(Player player) {
        return I18n.m_118938_((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[]{this.getDescriptionFormatArguments(player)[0]});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatBase)) {
            return false;
        }
        StatBase statBase = (StatBase)o;
        return Objects.equals(this.getRegistryName(), statBase.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    @Override
    public boolean isEnabled() {
        return this.getLimit() != 0 && this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getCostMultiplier() {
        return (Double)((StatConfig)this.config).costMultiplier.get();
    }

    public void setCostMultiplier(double costMultiplier) {
        ((StatConfig)this.config).costMultiplier.set((Object)costMultiplier);
    }

    public double getBonusMultiplier() {
        return (Double)((StatConfig)this.config).bonusMultiplier.get();
    }

    public void setBonusMultiplier(double bonusMultiplier) {
        ((StatConfig)this.config).bonusMultiplier.set((Object)bonusMultiplier);
    }
}

