/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStats;
import net.infstudio.goki.common.utils.DataHelper;
import net.infstudio.goki.common.utils.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GuiStatButton
extends Button {
    public StatBase stat;
    public Player player;
    public static final int INACTIVE_X = 0;
    public static final int ACTIVATED_X = 24;
    public static final int DISABLED_X = 48;
    public static final int MAXIMUM_X = 72;
    public final int id;
    private final Minecraft mc = Minecraft.m_91087_();

    public GuiStatButton(int id, int x, int y, int width, int height, StatBase stat, Player player, Button.OnPress onPress) {
        super(x, y, width, height, TextComponent.f_131282_, onPress);
        this.id = id;
        this.stat = stat;
        this.player = player;
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            int iconY = 24 * (this.stat.imageID % 10);
            int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
            int cost = this.stat.getCost(level);
            int playerXP = DataHelper.getXPTotal(this.player);
            Font fontrenderer = this.mc.f_91062_;
            this.f_93622_ = this.isUnderMouse(mouseX, mouseY);
            int iconX = 0;
            if (this.f_93622_) {
                iconX = 24;
            }
            if (playerXP < cost) {
                iconX = 0;
            }
            if (level >= this.stat.getLimit()) {
                iconX = 72;
            }
            if (Screen.m_96637_()) {
                iconX = DataHelper.canPlayerRevertStat(this.player, this.stat) ? 24 : 48;
            }
            if (!this.stat.isEnabled()) {
                iconX = 48;
            }
            Object message = "" + level;
            if (!this.stat.isEnabled()) {
                iconX = 48;
                message = "X";
            }
            int messageColor = 0xFFFFFF;
            if (level >= this.stat.getLimit()) {
                message = "*" + level + "*";
                messageColor = 0xFFCC00;
            }
            stack.m_85836_();
            stack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
            stack.m_85841_(GuiStats.SCALE, GuiStats.SCALE, 0.0f);
            this.bindTexture();
            this.m_93228_(stack, 0, 0, iconX += this.stat.imageID % 20 / 10 * 24 * 4, iconY, this.f_93618_, this.f_93619_);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
            GuiStatButton.m_93208_((PoseStack)stack, (Font)fontrenderer, (String)message, (int)((int)((float)(this.f_93618_ / 2) * GuiStats.SCALE)), (int)((int)((float)this.f_93619_ * GuiStats.SCALE) + 2), (int)messageColor);
            stack.m_85849_();
        }
    }

    public void bindTexture() {
        if (this.stat.imageID >= 20) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Reference.RPG_ICON_2_TEXTURE_LOCATION);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Reference.RPG_ICON_TEXTURE_LOCATION);
        }
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && (float)mouseX < (float)this.f_93620_ + (float)this.f_93618_ * GuiStats.SCALE && (float)mouseY < (float)this.f_93621_ + (float)this.f_93619_ * GuiStats.SCALE;
    }

    public void m_5716_(double p_onClick_1_, double p_onClick_3_) {
        super.m_5716_(p_onClick_1_, p_onClick_3_);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int mouseX, int mouseY) {
        return this.f_93623_ && this.f_93624_ && mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && (float)mouseX < (float)this.f_93620_ + (float)this.f_93618_ * GuiStats.SCALE && (float)mouseY < (float)this.f_93621_ + (float)this.f_93619_ * GuiStats.SCALE;
    }

    public String getHoverMessage(int which) {
        if (which == 0) {
            return this.stat.getLocalizedName() + " L" + DataHelper.getPlayerStatLevel(this.player, this.stat);
        }
        return this.stat.getLocalizedDescription(this.player);
    }
}

