/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;

public class GuiStatTooltip
extends GuiComponent {
    private StatBase stat;
    private Player player;
    private int padding = 4;
    private final Minecraft mc = Minecraft.m_91087_();

    public GuiStatTooltip(StatBase stat, Player player) {
        this.stat = stat;
        this.player = player;
    }

    public void render(PoseStack stack, int drawX, int drawY, float partialTicks) {
        int rightEdge;
        int right;
        int revertLevel;
        LinkedHashMap<Object, Integer> messageColorMap = new LinkedHashMap<Object, Integer>();
        AtomicInteger widthAtomic = new AtomicInteger();
        AtomicInteger heightAtomic = new AtomicInteger();
        int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
        messageColorMap.put(this.stat.getLocalizedName() + " L" + level, -13312);
        messageColorMap.put(this.stat.getLocalizedDescription(this.player), -1);
        if (level >= this.stat.getLimit()) {
            messageColorMap.put(I18n.m_118938_((String)"ui.max", (Object[])new Object[0]), -16724737);
        } else {
            messageColorMap.put(I18n.m_118938_((String)"ui.cost", (Object[])new Object[]{this.stat.getCost(level)}), -16724737);
        }
        if (Screen.m_96637_()) {
            messageColorMap.put(I18n.m_118938_((String)"ui.return", (Object[])new Object[]{(double)this.stat.getCost(level) * (Double)GokiConfig.SERVER.globalRevertFactor.get()}), -16724737);
        }
        if ((revertLevel = DataHelper.getPlayerRevertStatLevel(this.player, this.stat)) > 0) {
            if ((Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() != -1) {
                messageColorMap.put(I18n.m_118938_((String)"ui.reverted", (Object[])new Object[]{revertLevel, String.valueOf(GokiConfig.SERVER.globalMaxRevertLevel.get())}), -16724737);
            } else {
                messageColorMap.put(I18n.m_118938_((String)"ui.reverted", (Object[])new Object[]{revertLevel, I18n.m_118938_((String)"ui.infinite", (Object[])new Object[0])}), -16724737);
            }
        }
        if (Screen.m_96637_()) {
            if (DataHelper.canPlayerRevertStat(this.player, this.stat)) {
                messageColorMap.put(I18n.m_118938_((String)"ui.revert", (Object[])new Object[0]), -16488449);
            } else {
                messageColorMap.put(I18n.m_118938_((String)"ui.norevert", (Object[])new Object[0]), -321024);
            }
        } else {
            messageColorMap.put(I18n.m_118938_((String)"ui.hover", (Object[])new Object[0]), -16488449);
        }
        messageColorMap.forEach((text, color) -> {
            widthAtomic.set(Math.max(widthAtomic.get(), this.mc.f_91062_.m_92895_(text)));
            Objects.requireNonNull(this.mc.f_91062_);
            heightAtomic.addAndGet(9);
        });
        int width = widthAtomic.get() + this.padding * 2;
        int height = heightAtomic.get() + this.padding * 2;
        int h = height / messageColorMap.size();
        int x = drawX - width / 2;
        int leftEdge = 0;
        int left = x;
        if (left < leftEdge) {
            x -= leftEdge - left + 1;
        }
        if ((right = x + width) > (rightEdge = this.mc.f_91080_.f_96543_)) {
            x += rightEdge - right - 1;
        }
        GuiStatTooltip.m_93172_((PoseStack)stack, (int)x, (int)drawY, (int)(x + width), (int)(drawY - height), (int)-872415232);
        for (int i = messageColorMap.size(); i >= 1; --i) {
            Map.Entry entry = messageColorMap.entrySet().toArray(new Map.Entry[0])[messageColorMap.size() - i];
            GuiStatTooltip.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)((String)entry.getKey()), (int)(x + this.padding / 2), (int)(drawY - h * i + this.padding / 2), (int)((Integer)entry.getValue()));
        }
        this.drawBorder(stack, x, drawY, width, height, -1);
    }

    private void drawBorder(PoseStack stack, int x, int y, int width, int height, int borderColor) {
        this.m_93154_(stack, x - 1, x + width, y, borderColor);
        this.m_93154_(stack, x - 1, x + width, y - height, borderColor);
        this.m_93222_(stack, x - 1, y, y - height, borderColor);
        this.m_93222_(stack, x + width, y, y - height, borderColor);
    }
}

