/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStatButton;
import net.infstudio.goki.client.gui.GuiStatTooltip;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.C2SRequestStatSync;
import net.infstudio.goki.common.network.message.C2SStatSync;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;

public class GuiStats
extends Screen {
    public static final int STATUS_BUTTON_WIDTH = 24;
    public static final int STATUS_BUTTON_HEIGHT = 24;
    public static final int IMAGE_ROWS = 10;
    private static final int[] COLUMNS = new int[]{4, 4, 5, 4, 5, 4};
    public static float SCALE = 1.0f;
    private final Player player;
    private final Font fontRenderer;
    private int currentColumn;
    private int currentRow;
    private GuiStatTooltip toolTip;

    public GuiStats() {
        super((Component)new TextComponent(""));
        this.player = Minecraft.m_91087_().f_91074_;
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.currentColumn = 0;
        this.currentRow = 0;
        this.toolTip = null;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float par3) {
        int toolTipX = 0;
        int toolTipY = 0;
        this.toolTip = null;
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, par3);
        for (int i = 0; i < this.f_169369_.size(); ++i) {
            GuiStatButton button;
            Object e = this.f_169369_.get(i);
            if (!(e instanceof GuiStatButton) || !(button = (GuiStatButton)((Object)e)).isUnderMouse(mouseX, mouseY)) continue;
            this.toolTip = new GuiStatTooltip((StatBase)StatBase.stats.get(i), this.player);
            toolTipX = button.f_93620_ + 12;
            toolTipY = button.f_93621_ - 1;
            break;
        }
        GuiStats.m_93208_((PoseStack)stack, (Font)this.fontRenderer, (String)I18n.m_118938_((String)"ui.currentxp", (Object[])new Object[]{DataHelper.getXPTotal(this.player)}), (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 16), (int)-1);
        if (this.toolTip != null) {
            this.toolTip.render(stack, toolTipX, toolTipY, 0.0f);
        }
    }

    public void m_7856_() {
        GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SRequestStatSync());
        for (int stat = 0; stat < (Integer)StatBase.totalStats.orElse((Object)0); ++stat) {
            Vec2 pos = this.getButton(stat);
            this.m_142416_((GuiEventListener)new GuiStatButton(stat, (int)pos.f_82470_, (int)pos.f_82471_, 24, 24, (StatBase)StatBase.stats.get(stat), this.player, this::actionPerformed));
            ++this.currentColumn;
            if (this.currentColumn >= COLUMNS[this.currentRow]) {
                ++this.currentRow;
                this.currentColumn = 0;
            }
            if (this.currentRow < COLUMNS.length) continue;
            this.currentRow = COLUMNS.length - 1;
        }
    }

    private Vec2 getButton(int n) {
        int columns = COLUMNS[this.currentRow];
        int x = n % columns;
        int y = this.currentRow;
        int rows = COLUMNS.length;
        float width = (float)(columns * 32) * SCALE;
        float height = (float)(rows * 36) * SCALE;
        return new Vec2(width / (float)columns * (float)x + ((float)this.f_96543_ - width + 8.0f) / 2.0f, height / (float)rows * (float)y + ((float)this.f_96544_ - height + 12.0f) / 2.0f);
    }

    protected void actionPerformed(Button btn) {
        if (!(btn instanceof GuiStatButton)) {
            return;
        }
        GuiStatButton button = (GuiStatButton)btn;
        if (button.id >= 0 && button.id <= (Integer)StatBase.totalStats.orElse((Object)0)) {
            if (!GuiStats.m_96637_()) {
                GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SStatSync(StatBase.stats.indexOf((Object)button.stat), 1));
            } else {
                GokiPacketHandler.CHANNEL.sendToServer((Object)new C2SStatSync(StatBase.stats.indexOf((Object)button.stat), -1));
            }
        }
    }
}

