/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.network.handler;

import java.util.function.Supplier;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.network.message.S2CStatSync;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncClientHandler {
    public static void acceptSync(S2CStatSync message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncClientHandler.acceptSyncInternal(message)));
        ctx.setPacketHandled(true);
    }

    public static void acceptSyncAll(S2CSyncAll message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncClientHandler.acceptSyncAllInternal(message)));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptSyncInternal(S2CStatSync message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        StatBase stat = (StatBase)StatBase.stats.get(message.stat);
        if (stat == Stats.MAX_HEALTH) {
            player.m_21051_(Attributes.f_22276_).m_22100_((double)(20 + message.amount));
        }
        DataHelper.setPlayerRevertStatLevel((Player)player, stat, message.reverted);
        DataHelper.setPlayerStatLevel((Player)player, stat, message.amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptSyncAllInternal(S2CSyncAll message) {
        int i;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        for (i = 0; i < message.statLevels.length; ++i) {
            DataHelper.setPlayerStatLevel((Player)player, (Stat)StatBase.stats.get(i), message.statLevels[i]);
        }
        for (i = 0; i < message.revertedStatLevels.length; ++i) {
            DataHelper.setPlayerRevertStatLevel((Player)player, (Stat)StatBase.stats.get(i), message.revertedStatLevels[i]);
        }
        player.m_21051_(Attributes.f_22276_).m_22100_((double)(20 + DataHelper.getPlayerStatLevel((Player)player, Stats.MAX_HEALTH)));
    }
}

