/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatSpecial;
import net.infstudio.goki.api.stat.StatStorage;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.handlers.SyncEventHandler;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="gokistats")
@Mod.EventBusSubscriber(modid="gokistats")
public class CommonHandler {
    @SubscribeEvent
    public static void injectCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("gokistats", "stat_storage"), (ICapabilityProvider)new CapabilityStat.Provider());
        }
    }

    @SubscribeEvent
    public static void playerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            int featherFallLevel = DataHelper.getPlayerStatLevel(player, Stats.STAT_FEATHER_FALL);
            if ((double)event.getDistance() < 3.0 + (double)featherFallLevel * 0.1) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        ((StatStorage)event.getPlayer().getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap = ((StatStorage)event.getOriginal().getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap;
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.m_5776_()) {
            if (((Boolean)GokiConfig.SERVER.loseStatsOnDeath.get()).booleanValue()) {
                for (int stat = 0; stat < (Integer)StatBase.totalStats.orElse((Object)0); ++stat) {
                    DataHelper.multiplyPlayerStatLevel(player, (Stat)StatBase.stats.get(stat), level -> level - (int)((Double)GokiConfig.SERVER.loseStatsMultiplier.get() * (double)level));
                }
            }
            SyncEventHandler.syncPlayerData(player);
            player.m_5634_(player.m_21233_());
        }
    }

    @SubscribeEvent
    public static void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getPlayer().m_21205_();
        Player player = event.getPlayer();
        double multiplier = 1.0;
        if (Stats.MINING.isEffectiveOn(heldItem, event.getPos(), player.f_19853_)) {
            multiplier += Stats.MINING.getBonus(player);
        }
        if (Stats.DIGGING.isEffectiveOn(heldItem, event.getPos(), player.f_19853_)) {
            multiplier += Stats.DIGGING.getBonus(player);
        }
        if (Stats.CHOPPING.isEffectiveOn(heldItem, event.getPos(), player.f_19853_)) {
            multiplier += Stats.CHOPPING.getBonus(player);
        }
        if (Stats.TRIMMING.isEffectiveOn(heldItem, event.getPos(), player.f_19853_)) {
            multiplier += Stats.TRIMMING.getBonus(player);
        }
        event.setNewSpeed((float)((double)event.getOriginalSpeed() * multiplier));
    }

    @SubscribeEvent
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20142_()) {
            player.m_20256_(player.m_20184_().m_82542_(1.0 + Stats.LEAPER_V.getBonus(player), 1.0 + Stats.LEAPER_H.getBonus(player), 1.0 + Stats.LEAPER_H.getBonus(player)));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        Entity src;
        DamageSource source = event.getSource();
        LivingEntity victim = event.getEntityLiving();
        if (victim instanceof Player) {
            Player player = (Player)victim;
            if (!source.m_19384_() && !source.m_19379_() && (double)player.f_19853_.f_46441_.nextFloat() >= 1.0 - Stats.ROLL.getBonus(player)) {
                event.setCanceled(true);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, 2));
                victim.m_20049_("knockback");
                return;
            }
            double damageMultiplier = 1.0 - (Stats.PROTECTION.getAppliedBonus(player, source) + Stats.TOUGH_SKIN.getAppliedBonus(player, source) + Stats.STAT_FEATHER_FALL.getAppliedBonus(player, source) + Stats.TEMPERING.getAppliedBonus(player, source));
            event.setAmount((float)((double)event.getAmount() * damageMultiplier));
        }
        if ((src = source.m_7639_()) instanceof Player) {
            Player player = (Player)src;
            ItemStack heldItem = player.m_21205_();
            float damage = event.getAmount();
            float bonus = 0.0f;
            if (!heldItem.m_41619_()) {
                if (Stats.SWORDSMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round((double)damage * Stats.SWORDSMANSHIP.getAppliedBonus(player, heldItem));
                } else if (Stats.BOWMANSHIP.isItemSupported(heldItem)) {
                    bonus = Math.round((double)damage * Stats.BOWMANSHIP.getAppliedBonus(player, heldItem));
                } else if (!DataHelper.hasDamageModifier(heldItem)) {
                    bonus = Math.round((double)damage + Stats.PUGILISM.getBonus(player));
                }
            } else {
                bonus = Math.round((double)damage + Stats.PUGILISM.getBonus(player));
            }
            event.setAmount(bonus + damage);
            if (Stats.REAPER.isEffectiveOn(victim)) {
                double reap = Stats.REAPER.getBonus(player);
                double reapBonus = 0.0;
                if (Stats.STEALTH.isEffectiveOn(player)) {
                    reapBonus = reap * ((StatSpecial)((Object)Stats.STEALTH)).getSecondaryBonus(player) / 100.0;
                }
                double reapChance = reap + reapBonus;
                if ((double)player.m_21187_().nextFloat() <= reapChance) {
                    player.m_5704_((Entity)victim);
                    player.f_19853_.m_5594_(player, event.getEntity().m_142538_(), GokiSounds.REAPER, SoundSource.MASTER, 1.0f, 1.0f);
                    event.setAmount(100000.0f);
                }
            }
        }
    }
}

