/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.stat.tool.StatMiningMagician;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class GokiLootModifier
extends LootModifier {
    private static ResourceLocation temp = new ResourceLocation("minecraft:null");

    protected GokiLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!(context.m_78936_(LootContextParams.f_81461_) && context.m_78936_(LootContextParams.f_81455_) && context.m_78936_(LootContextParams.f_81460_))) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof Player)) {
            return generatedLoot;
        }
        Player player = (Player)entity;
        Block block = ((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_();
        if (DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER) > 0) {
            ResourceLocation id = new ResourceLocation(block.getRegistryName().m_135827_(), "treasure_finder/" + block.getRegistryName().m_135815_());
            if (context.getQueriedLootTableId().equals((Object)temp)) {
                return generatedLoot;
            }
            temp = context.getQueriedLootTableId();
            LootTable table = context.m_78940_(id);
            List items = table.m_79129_(context);
            temp = new ResourceLocation("minecraft:null");
            generatedLoot.addAll(items);
            if (!items.isEmpty()) {
                player.f_19853_.m_5594_(player, new BlockPos((Vec3)context.m_78953_(LootContextParams.f_81460_)), GokiSounds.TREASURE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.MINING_MAGICIAN) > 0) {
            boolean magicHappened = false;
            if (Stats.MINING_MAGICIAN.isEffectiveOn(block)) {
                for (int i = 0; i < generatedLoot.size(); ++i) {
                    if (!(player.m_21187_().nextDouble() * 100.0 <= Stats.MINING_MAGICIAN.getBonus(player))) continue;
                    ItemStack item = generatedLoot.get(i);
                    if (item.m_41720_() instanceof BlockItem && Objects.equals(item.m_41720_().getRegistryName(), block.getRegistryName())) {
                        ItemStack stack = new ItemStack((ItemLike)StatMiningMagician.MAGICIAN_ORE.m_13288_(context.m_78933_()), 1);
                        stack.m_41764_(generatedLoot.get(i).m_41613_());
                        generatedLoot.add(stack);
                        magicHappened = true;
                        continue;
                    }
                    generatedLoot.add(new ItemStack((ItemLike)StatMiningMagician.MAGICIAN_ITEM.m_13288_(context.m_78933_()), generatedLoot.get(i).m_41613_()));
                    magicHappened = true;
                    break;
                }
                if (magicHappened) {
                    player.f_19853_.m_5594_(player, new BlockPos((Vec3)context.m_78953_(LootContextParams.f_81460_)), GokiSounds.MAGICIAN, SoundSource.BLOCKS, 0.3f, 1.0f);
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GokiLootModifier> {
        public GokiLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            return new GokiLootModifier(conditionsIn);
        }

        public JsonObject write(GokiLootModifier instance) {
            return new JsonObject();
        }
    }
}

