/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.handlers.SyncEventHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="gokistats")
public class TickHandler {
    public static final UUID knockbackResistanceID = UUID.randomUUID();
    public static final UUID stealthSpeedID = UUID.randomUUID();
    public static final UUID swimSpeedID = UUID.randomUUID();
    public static AtomicInteger tickTimer = new AtomicInteger();

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            Player player = event.player;
            TickHandler.handleTaskPlayerAPI(player);
            if (!player.m_6084_()) {
                return;
            }
            AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(stealthSpeedID, "SneakSpeed", Stats.STEALTH.getBonus(player) / 100.0, AttributeModifier.Operation.m_22236_((int)1));
            if (player.m_6047_()) {
                if (attributeInstance.m_22111_(stealthSpeedID) == null) {
                    attributeInstance.m_22118_(modifier);
                }
            } else if (attributeInstance.m_22111_(stealthSpeedID) != null) {
                attributeInstance.m_22130_(modifier);
            }
            if ((attributeInstance = player.m_21051_(Attributes.f_22278_)) == null) {
                return;
            }
            modifier = new AttributeModifier(knockbackResistanceID, "KnockbackResistance", Stats.STEADY_GUARD.getBonus(player), AttributeModifier.Operation.m_22236_((int)0));
            if (player.m_21254_()) {
                if (attributeInstance.m_22111_(knockbackResistanceID) == null) {
                    attributeInstance.m_22118_(modifier);
                }
            } else if (attributeInstance.m_22111_(knockbackResistanceID) != null) {
                attributeInstance.m_22130_(modifier);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && (Integer)GokiConfig.SERVER.syncTicks.get() > 0) {
            if (tickTimer.get() == ((Integer)GokiConfig.SERVER.syncTicks.get()).intValue()) {
                tickTimer.lazySet(0);
                for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                    SyncEventHandler.syncPlayerData((Player)player);
                }
            } else {
                tickTimer.getAndIncrement();
            }
        }
    }

    public static boolean isJumping(LivingEntity livingBase) {
        return Boolean.TRUE.equals(ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingBase, (String)"field_70703_bu"));
    }

    private static void handleTaskPlayerAPI(Player player) {
        if ((!player.m_7578_() || player.canRiderInteract()) && player.m_6147_() && !player.m_6144_()) {
            double multiplier = Stats.CLIMBING.getBonus(player);
            player.m_6478_(MoverType.SELF, player.m_20184_().m_82542_(1.0, multiplier, 1.0));
        }
    }
}

