/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.network.handler;

import java.util.function.Supplier;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.C2SRequestStatSync;
import net.infstudio.goki.common.network.message.C2SStatSync;
import net.infstudio.goki.common.network.message.S2CStatSync;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.stat.StatMaxHealth;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketSyncHandler {
    public static void acceptC2S(C2SStatSync message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ServerPlayer player = ctx.getSender();
        StatBase stat = (StatBase)StatBase.stats.get(message.stat);
        if (!stat.isEnabled()) {
            return;
        }
        int reverted = DataHelper.getPlayerRevertStatLevel((Player)player, stat);
        if ((Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() < reverted - message.amount && (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() != -1) {
            return;
        }
        int level = DataHelper.getPlayerStatLevel((Player)player, stat);
        if (message.amount < 0 && level == 0) {
            return;
        }
        if (level + message.amount > stat.getLimit()) {
            return;
        }
        int cost = stat.getCost(level + message.amount - 1);
        int currentXP = DataHelper.getXPTotal((Player)player);
        ctx.enqueueWork(() -> {
            if (message.amount <= 0) {
                DataHelper.setPlayerRevertStatLevel((Player)player, stat, reverted);
                player.m_6756_((int)((double)stat.getCost(level + message.amount) * (Double)GokiConfig.SERVER.globalRevertFactor.get()));
                if (stat instanceof StatMaxHealth) {
                    player.m_21051_(Attributes.f_22276_).m_22100_(20.0 + stat.getBonus(level) + (double)message.amount);
                }
                DataHelper.setPlayerStatLevel((Player)player, stat, level + message.amount);
                GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level + message.amount, reverted));
            } else if (currentXP >= cost) {
                if (stat instanceof StatMaxHealth) {
                    player.m_21051_(Attributes.f_22276_).m_22100_(20.0 + stat.getBonus(level) + (double)message.amount);
                }
                if (message.amount <= 0) {
                    player.m_6756_((int)((double)stat.getCost(level + message.amount + 1) * (Double)GokiConfig.SERVER.globalRevertFactor.get()));
                } else {
                    player.m_6756_(-cost);
                    DataHelper.setPlayerStatLevel((Player)player, stat, level + message.amount);
                }
                GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level + message.amount, reverted));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void onRequestSyncAll(C2SRequestStatSync message, Supplier<NetworkEvent.Context> ctx) {
        GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx.get()).getSender()), (Object)new S2CSyncAll((Player)ctx.get().getSender()));
        ctx.get().setPacketHandled(true);
    }
}

