/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record StatLootCondition(Stat stat, int minLevel) implements LootItemCondition
{
    @Nonnull
    public static final LootItemConditionType STAT_LOOT_CONDITION = (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("gokistats", "stat_level"), (Object)new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer()));

    @Nonnull
    public LootItemConditionType m_7940_() {
        return STAT_LOOT_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        Object object = lootContext.m_78953_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player player = (Player)object;
            return DataHelper.getPlayerStatLevel(player, this.stat) >= this.minLevel;
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<StatLootCondition> {
        public void serialize(@Nonnull JsonObject object, @Nonnull StatLootCondition condition, @Nonnull JsonSerializationContext context) {
            object.addProperty("stat", Objects.requireNonNull(condition.stat().getRegistryName()).toString());
            object.addProperty("minLevel", (Number)condition.minLevel());
        }

        @Nonnull
        public StatLootCondition deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext context) {
            Stat stat = (Stat)StatBase.REGISTRY.getValue(new ResourceLocation(object.get("stat").getAsString()));
            int minLevel = object.get("minLevel").getAsInt();
            return new StatLootCondition(stat, minLevel);
        }
    }
}

