/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class StatReaper
extends StatBase {
    public StatReaper(int id, String key, int limit) {
        super(id, key, limit);
    }

    @Override
    public double getBonus(int level) {
        return this.getFinalBonus((float)Math.pow(level, 1.0768) * 0.0025f);
    }

    @Override
    public double[] getDescriptionFormatArguments(Player player) {
        return new double[]{DataHelper.trimDecimals(this.getBonus(this.getPlayerStatLevel(player)) * 100.0, 1), ((Integer)GokiConfig.SERVER.reaperLimit.get()).intValue()};
    }

    @Override
    public String getLocalizedDescription(Player player) {
        return I18n.m_118938_((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[]{this.getDescriptionFormatArguments(player)[0], this.getDescriptionFormatArguments(player)[1]});
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] != null && !(obj[0] instanceof Player) && obj[0] instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)obj[0];
            int limit = (Integer)GokiConfig.SERVER.reaperLimit.get();
            return target.m_21233_() <= (float)limit || limit == -1;
        }
        return false;
    }
}

