/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat.special.leaper;

import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.stat.special.leaper.StatLeaper;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;

public class StatStealth
extends StatLeaper {
    public StatStealth(int id, String key, int limit) {
        super(id, key, limit);
    }

    @Override
    public double getBonus(int level) {
        return this.getFinalBonus((float)Math.pow(level, 1.3416));
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        return obj[0] instanceof Player && ((Player)obj[0]).m_6144_();
    }

    @Override
    public double getSecondaryBonus(int level) {
        return this.getFinalBonus((float)Math.pow(level, 1.4307));
    }

    @Override
    public double[] getDescriptionFormatArguments(Player player) {
        double speed = DataHelper.trimDecimals(this.getBonus(player), 1);
        double reapBonus = DataHelper.trimDecimals(this.getSecondaryBonus(player), 1);
        double reap = Stats.REAPER.getBonus(player) * 100.0;
        double newReap = DataHelper.trimDecimals(reap + reap * reapBonus / 100.0, 1);
        return new double[]{speed, reapBonus, newReap};
    }

    @Override
    public String getLocalizedDescription(Player player) {
        return I18n.m_118938_((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[]{this.getDescriptionFormatArguments(player)[0], this.getDescriptionFormatArguments(player)[1], this.getDescriptionFormatArguments(player)[2]});
    }
}

