/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.utils;

import java.util.Collection;
import java.util.function.IntFunction;
import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.Stat;
import net.infstudio.goki.api.stat.StatStorage;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class DataHelper {
    public static boolean canPlayerRevertStat(Player player, Stat stat) {
        return (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() == -1 || (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() >= 0 && DataHelper.getPlayerRevertStatLevel(player, stat) < (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() && DataHelper.getPlayerStatLevel(player, stat) > 0;
    }

    public static int getPlayerRevertStatLevel(Player player, Stat stat) {
        return ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).revertedLevel;
    }

    public static void setPlayerRevertStatLevel(Player player, Stat stat, int level) {
        ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).revertedLevel = level;
    }

    public static int getPlayerStatLevel(Player player, Stat stat) {
        return ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).level;
    }

    public static void setPlayerStatLevel(Player player, Stat stat, int level) {
        ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).level = level;
    }

    public static void multiplyPlayerStatLevel(Player player, Stat stat, IntFunction<Integer> multiplier) {
        DataHelper.setPlayerStatLevel(player, stat, multiplier.apply(DataHelper.getPlayerStatLevel(player, stat)));
    }

    public static void addMaxHealth(Player player, int amount) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
        attribute.m_22100_((double)(20 + amount));
        attribute.m_22132_();
        attribute.m_22125_(new AttributeModifier("MaxHealth", (double)DataHelper.getPlayerStatLevel(player, Stats.MAX_HEALTH), AttributeModifier.Operation.ADDITION));
    }

    public static void resetMaxHealth(Player player) {
        DataHelper.addMaxHealth(player, DataHelper.getPlayerStatLevel(player, Stats.MAX_HEALTH));
    }

    public static double trimDecimals(double in, int decimals) {
        float f = (float)(in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static int getXPTotal(Player player) {
        int level = player.f_36078_;
        int xp = player.f_36079_;
        if (level >= 0 && level <= 15) {
            xp = (int)Math.round(Math.pow(level, 2.0) + (double)(6 * level));
        } else if (level > 15 && level <= 30) {
            xp = (int)Math.round(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        } else if (level > 30) {
            xp = (int)Math.round(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return xp;
    }

    public static boolean hasDamageModifier(ItemStack stack) {
        Collection modifiers = stack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, stack).get((Object)Attributes.f_22281_);
        return !modifiers.isEmpty();
    }

    public static float getDamageDealt(Player player, Entity target, DamageSource source) {
        float damage = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof LivingEntity;
        ItemStack stack = player.m_21205_();
        if (targetIsLiving) {
            bonusDamage += EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)target).m_6336_());
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean critical;
            boolean bl = critical = player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && player.m_20202_() == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(LivingEntity entity) {
        float resistance = 3.0f;
        MobEffectInstance potionEffect = entity.m_21124_(MobEffects.f_19603_);
        float bonus = potionEffect != null ? (float)(potionEffect.m_19564_() + 1) : 0.0f;
        return resistance + bonus;
    }
}

