/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks;

import com.legacy.goodnightsleep.capabillity.DreamPlayer;
import com.legacy.goodnightsleep.network.PacketHandler;
import com.legacy.goodnightsleep.network.SendEnteredTimePacket;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSDimensions;
import com.legacy.goodnightsleep.tile_entity.TileEntityLuxuriousBed;
import com.legacy.goodnightsleep.tile_entity.TileEntityStrangeBed;
import com.legacy.goodnightsleep.tile_entity.TileEntityWretchedBed;
import com.legacy.goodnightsleep.world.GNSTeleporter;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GNSBedBlock
extends BedBlock {
    public GNSBedBlock(AbstractBlock.Properties properties) {
        super(DyeColor.WHITE, properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (player.field_70170_p.func_234923_W_() == World.field_234918_g_) {
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_242111_a(World.field_234918_g_, pos, 0.0f, false, false);
                }
                player.func_213369_d(pos);
            }
            if (this == GNSBlocks.luxurious_bed) {
                this.travelToDream(player, true);
            } else if (this == GNSBlocks.wretched_bed) {
                this.travelToDream(player, false);
            } else if (this == GNSBlocks.strange_bed) {
                this.travelToDream(player, worldIn.field_73012_v.nextBoolean());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    private void travelToDream(PlayerEntity player, boolean dream) {
        RegistryKey<World> transferDimension;
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        RegistryKey<World> registryKey = transferDimension = player.field_70170_p.func_234923_W_() == GNSDimensions.getDimensionKeys(dream) ? World.field_234918_g_ : GNSDimensions.getDimensionKeys(dream);
        if (transferDimension != World.field_234918_g_ && DreamPlayer.get((PlayerEntity)serverPlayer) != null) {
            DreamPlayer.get((PlayerEntity)serverPlayer).setEnteredDreamTime(serverPlayer.field_70170_p.func_82737_E());
            PacketHandler.sendTo(new SendEnteredTimePacket(serverPlayer.field_70170_p.func_82737_E()), serverPlayer);
        }
        try {
            ServerWorld serverWorld = player.func_184102_h().func_71218_a(World.field_234918_g_);
            BlockPos pos = player.field_70170_p.func_234923_W_() != World.field_234918_g_ ? serverPlayer.func_241140_K_() : serverWorld.func_241135_u_();
            GNSTeleporter.changeDimension(transferDimension, (Entity)player, pos);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this == GNSBlocks.luxurious_bed) {
            return new TileEntityLuxuriousBed();
        }
        if (this == GNSBlocks.wretched_bed) {
            return new TileEntityWretchedBed();
        }
        return new TileEntityStrangeBed();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

