/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.client;

import com.legacy.goodnightsleep.capabillity.DreamPlayer;
import com.legacy.goodnightsleep.registry.GNSDimensions;
import com.legacy.goodnightsleep.world.DreamSkyRenderer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GNSClientEvents {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final DimensionRenderInfo DREAM_RENDER_INFO = new DreamRenderInfo();
    private static final DimensionRenderInfo NIGHTMARE_RENDER_INFO = new NightmareRenderInfo();
    private static final Object2ObjectMap<ResourceLocation, DimensionRenderInfo> DIMENSION_RENDER_INFO = (Object2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(DimensionRenderInfo.class, (Object)DREAM_RENDER_INFO, (String)"field_239208_a_");

    public static void initDimensionRenderInfo() {
        DIMENSION_RENDER_INFO.put((Object)GNSDimensions.DREAM_ID, (Object)DREAM_RENDER_INFO);
        DIMENSION_RENDER_INFO.put((Object)GNSDimensions.NIGHTMARE_ID, (Object)NIGHTMARE_RENDER_INFO);
    }

    @SubscribeEvent
    public void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (GNSClientEvents.shouldNightmareFogRender()) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            RenderSystem.fogDensity((float)0.035f);
            RenderSystem.enableFog();
        }
    }

    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = GNSClientEvents.mc.field_71441_e;
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (GNSClientEvents.mc.field_71439_g != null && DreamPlayer.get((PlayerEntity)GNSClientEvents.mc.field_71439_g) != null) {
            DreamPlayer.get((PlayerEntity)GNSClientEvents.mc.field_71439_g).clientTick();
        }
    }

    private static boolean shouldNightmareFogRender() {
        return GNSClientEvents.mc.field_71441_e.func_234923_W_() == GNSDimensions.getDimensionKeys(false) && !GNSClientEvents.mc.field_71439_g.func_208600_a((ITag)FluidTags.field_206960_b) && !GNSClientEvents.mc.field_71439_g.func_208600_a((ITag)FluidTags.field_206959_a) && !GNSClientEvents.mc.field_71439_g.func_70644_a(Effects.field_76440_q);
    }

    public static float calculateSunAngle(long worldTimeIn, float partialTicks) {
        ClientPlayerEntity player = GNSClientEvents.mc.field_71439_g;
        long worldTime = DreamPlayer.get((PlayerEntity)player) != null ? worldTimeIn - DreamPlayer.get((PlayerEntity)player).getEnteredDreamTime() : worldTimeIn;
        int j = (int)(worldTime % 48000L);
        float f1 = ((float)j + partialTicks) / 48000.0f - 0.25f;
        if (player.field_70170_p.func_234923_W_() == GNSDimensions.getDimensionKeys(false)) {
            f1 += 0.5f;
        }
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static class NightmareRenderInfo
    extends DimensionRenderInfo.Overworld {
        public Vector3d func_230494_a_(Vector3d fogColor, float fogBrightness) {
            return fogColor;
        }

        public boolean func_230493_a_(int posX, int posZ) {
            return true;
        }

        public ISkyRenderHandler getSkyRenderHandler() {
            return DreamSkyRenderer.INSTANCE;
        }
    }

    public static class DreamRenderInfo
    extends DimensionRenderInfo.Overworld {
        public ISkyRenderHandler getSkyRenderHandler() {
            return DreamSkyRenderer.INSTANCE;
        }
    }
}

