/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.client.resource_pack;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;

public class GNSResourcePack
extends ResourcePack {
    private static ModFile modFile = ModList.get().getModFileById("good_nights_sleep").getFile();
    private static String subFolder = "";
    private String name = "";

    public GNSResourcePack(String subFolderIn, String nameIn) {
        super(modFile.getFilePath().toFile());
        subFolder = subFolderIn;
        this.name = nameIn;
    }

    public String func_195762_a() {
        return this.name;
    }

    private static String getSubFolders() {
        return subFolder;
    }

    public void close() {
    }

    protected InputStream func_195766_a(String name) throws IOException {
        Path path = modFile.getLocator().findPath((IModFile)modFile, new String[]{GNSResourcePack.getSubFolders() + name});
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ResourcePackFileNotFoundException(path.toFile(), GNSResourcePack.getSubFolders() + name);
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean func_195768_c(String name) {
        return Files.exists(modFile.getLocator().findPath((IModFile)modFile, new String[]{GNSResourcePack.getSubFolders() + name}), new LinkOption[0]);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = modFile.getLocator().findPath((IModFile)modFile, new String[]{GNSResourcePack.getSubFolders() + type.func_198956_a()}).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 1 && path.getNameCount() - 1 <= maxDepth).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.subpath(1, path.getNameCount()).startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(path.getName(0).toString(), Joiner.on((char)'/').join((Iterable)path.subpath(1, Math.min(maxDepth, path.getNameCount()))))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        try {
            Path root = modFile.getLocator().findPath((IModFile)modFile, new String[]{GNSResourcePack.getSubFolders() + type.func_198956_a()}).toAbsolutePath();
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }
}

