/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.registry.GNSBiomes;
import com.legacy.goodnightsleep.registry.GNSEntityTypes;
import com.legacy.goodnightsleep.registry.GNSFeatures;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Logger;

public class GNSBiomeProv
extends BiomeProvider {
    private final DataGenerator generator = (DataGenerator)ObfuscationReflectionHelper.getPrivateValue(BiomeProvider.class, (Object)((Object)this), (String)"field_244197_d");
    private static final Gson gsonBuilder = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = GoodNightSleep.LOGGER;
    protected static Map<ResourceLocation, Biome> BIOMES = new HashMap<ResourceLocation, Biome>();

    public GNSBiomeProv(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void func_200398_a(DirectoryCache cache) {
        Makers.init();
        System.out.println("trying");
        LOGGER.info("burger beginning biome gen");
        Path path = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, Biome> entry : BIOMES.entrySet()) {
            Path path1 = GNSBiomeProv.createPath(path, entry.getKey());
            Biome biome = entry.getValue();
            Function function = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
            try {
                Optional optional = ((DataResult)function.apply(() -> biome)).result();
                if (optional.isPresent()) {
                    IDataProvider.func_218426_a((Gson)gsonBuilder, (DirectoryCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path1);
                    continue;
                }
                LOGGER.error("Couldn't serialize biome {}", (Object)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save biome {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path createPath(Path pathIn, ResourceLocation locationIn) {
        Path path = pathIn.resolve("data/" + locationIn.func_110624_b() + "/worldgen/biome/" + locationIn.func_110623_a() + ".json");
        System.out.println(path.toString());
        return path;
    }

    public static class Makers {
        public static final Biome SLEEPY_HILLS = Makers.createSleepyHillsBiome(0.1f, 0.5f, 0.5f, 0.0f, 4159204, 329011);
        public static final Biome GOOD_DREAM_PLAINS = Makers.createGoodDreamPlainsBiome(0.0f, 0.1f, 0.5f, 0.0f, 4159204, 329011);
        public static final Biome DREAMY_FOREST = Makers.createDreamyForestBiome(0.0f, 0.2f, 0.5f, 0.0f, 4159204, 329011);
        public static final Biome LOLLIPOP_LANDS = Makers.createLollipopLandsBiome(0.0f, 0.2f, 0.5f, 0.0f, 4159204, 329011);
        public static final Biome NIGHTMARE_HILLS = Makers.createNightmareBiome(0.1f, 1.0f, 0.8f, 0.0f, 4159204, 329011);
        public static final Biome SHAMEFUL_PLAINS = Makers.createShamefulPlainsBiome(0.1f, 0.1f, 0.8f, 0.0f, 4159204, 329011);
        public static final Biome WASTED_FOREST = Makers.createWastedForestBiome(0.0f, 0.1f, 0.8f, 0.0f, 4159204, 329011);
        public static final Biome HOPEFUL_FIELDS = Makers.createHopefulFieldsBiome(0.0f, 0.4f, 0.3f, 0.0f, 4159204, 329011);

        public static void init() {
            BIOMES.put(GoodNightSleep.locate("sleepy_hills"), SLEEPY_HILLS);
            BIOMES.put(GoodNightSleep.locate("good_dream_plains"), GOOD_DREAM_PLAINS);
            BIOMES.put(GoodNightSleep.locate("dreamy_forest"), DREAMY_FOREST);
            BIOMES.put(GoodNightSleep.locate("lollipop_lands"), LOLLIPOP_LANDS);
            BIOMES.put(GoodNightSleep.locate("hopeful_fields"), HOPEFUL_FIELDS);
            BIOMES.put(GoodNightSleep.locate("nightmare_hills"), NIGHTMARE_HILLS);
            BIOMES.put(GoodNightSleep.locate("shameful_plains"), SHAMEFUL_PLAINS);
            BIOMES.put(GoodNightSleep.locate("wasted_forest"), WASTED_FOREST);
        }

        public static Biome createSleepyHillsBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 140, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.UNICORN, 90, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.BABY_CREEPER, 10, 1, 4));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            GNSFeatures.addDreamTrees(builder);
            GNSFeatures.addHugeHopeMushrooms(builder);
            GNSFeatures.addScatteredDreamFeatures(builder);
            GNSFeatures.addDreamOres(builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_DREAM_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(0xFFFFFF).func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(12638463).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createGoodDreamPlainsBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 140, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.UNICORN, 90, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.BABY_CREEPER, 10, 1, 4));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PLAINS_DIAMOND_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PLAINS_HOPE_MUSHROOM);
            GNSFeatures.addScatteredDreamFeatures(builder);
            GNSFeatures.addDreamOres(builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_DREAM_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_FLOWERS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_LOLLIPOPS_20);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(0xFFFFFF).func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(12638463).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createDreamyForestBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 140, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.BABY_CREEPER, 10, 1, 4));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.FOREST_DREAM_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.FOREST_CANDY_TREE);
            GNSFeatures.addDreamSponges(builder);
            GNSFeatures.addDreamOres(builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_DREAM_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(0xFFFFFF).func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(12638463).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createLollipopLandsBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 140, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.BABY_CREEPER, 10, 1, 4));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.LANDS_CANDY_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.LANDS_DREAM_TREE);
            GNSFeatures.addDreamSponges(builder);
            GNSFeatures.addDreamOres(builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_DREAM_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(0xFFFFCC).func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(12638463).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createHopefulFieldsBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 140, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.UNICORN, 90, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.BABY_CREEPER, 10, 1, 4));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.DREAM_GRASS_SURFACE_BUILDER);
            GNSFeatures.addHopeMushroomFields(builder);
            GNSFeatures.addDreamSponges(builder);
            GNSFeatures.addDreamOres(builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_DREAM_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_FLOWERS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.DREAM_MUSHROOMS_25);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_242541_f(0xFFFFFF).func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(12638463).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createNightmareBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = Makers.getDefaultNightmareSpawns();
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.NIGHTMARE_GRASS_SURFACE_BUILDER);
            GNSFeatures.addNightmareTrees(builder);
            GNSFeatures.addHugeDespairMushrooms(builder);
            GNSFeatures.addScatteredNightmareFeatures(builder);
            GNSFeatures.addNightmareOres(builder);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_NIGHTMARE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PRICKLY_NIGHTMARE_GRASS_1);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NIGHTMARE_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(0x330808).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createShamefulPlainsBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = Makers.getDefaultNightmareSpawns();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(GNSEntityTypes.SPAWNER_ENTITY, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.NIGHTMARE_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PLAINS_BLOOD_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PLAINS_DESPAIR_MUSHROOM);
            GNSFeatures.addScatteredNightmareFeatures(builder);
            GNSFeatures.addNightmareOres(builder);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NOISE_BASED_NIGHTMARE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PRICKLY_NIGHTMARE_GRASS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NIGHTMARE_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(0x330808).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome createWastedForestBiome(float depthIn, float scaleIn, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
            MobSpawnInfo.Builder spawns = Makers.getDefaultNightmareSpawns();
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(GNSBiomes.SurfaceBuilders.NIGHTMARE_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.FOREST_DEAD_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.FOREST_BLOOD_TREE);
            GNSFeatures.addScatteredNightmareFeatures(builder);
            GNSFeatures.addNightmareOres(builder);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NIGHTMARE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.PRICKLY_NIGHTMARE_GRASS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, GNSFeatures.Configured.NIGHTMARE_FLOWERS_5);
            GNSFeatures.addCarvers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depthIn).func_205420_b(scaleIn).func_205414_c(tempIn).func_205417_d(downfallIn).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(waterColorIn).func_235248_c_(waterFogColorIn).func_235239_a_(0x330808).func_242539_d(Makers.calculateSkyColor(tempIn)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        private static MobSpawnInfo.Builder getDefaultNightmareSpawns() {
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.TORMENTER, 100, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(GNSEntityTypes.HEROBRINE, 10, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 95, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 5, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200811_y, 30, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_233592_ba_, 90, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200771_K, 2, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200740_af, 5, 4, 4));
            return spawns;
        }

        private static int calculateSkyColor(float tempIn) {
            float lvt_1_1_ = tempIn / 3.0f;
            lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
            return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
        }
    }
}

