/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.network;

import com.legacy.goodnightsleep.capabillity.DreamPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendEnteredTimePacket {
    private long enteredTime;

    public SendEnteredTimePacket(long timeIn) {
        this.enteredTime = timeIn;
    }

    public static void encoder(SendEnteredTimePacket packet, PacketBuffer buffer) {
        buffer.writeLong(packet.enteredTime);
    }

    public static SendEnteredTimePacket decoder(PacketBuffer buff) {
        return new SendEnteredTimePacket(buff.readLong());
    }

    public static void handler(SendEnteredTimePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SendEnteredTimePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SendEnteredTimePacket packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (DreamPlayer.get((PlayerEntity)player) != null) {
            DreamPlayer.get((PlayerEntity)player).setEnteredDreamTime(packet.enteredTime);
        }
    }
}

