/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.google.common.collect.ImmutableList;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.data.GNSBiomeProv;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSDimensions;
import com.legacy.goodnightsleep.registry.GNSRegistry;
import com.legacy.goodnightsleep.world.biome_provider.DreamBiomeProvider;
import com.legacy.goodnightsleep.world.biome_provider.NightmareBiomeProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class GNSBiomes {
    public static final Biome SLEEPY_HILLS = GNSBiomeProv.Makers.SLEEPY_HILLS;
    public static final Biome DREAMY_FOREST = GNSBiomeProv.Makers.DREAMY_FOREST;
    public static final Biome GOOD_DREAM_PLAINS = GNSBiomeProv.Makers.GOOD_DREAM_PLAINS;
    public static final Biome LOLLIPOP_LANDS = GNSBiomeProv.Makers.LOLLIPOP_LANDS;
    public static final Biome NIGHTMARE_HILLS = GNSBiomeProv.Makers.NIGHTMARE_HILLS;
    public static final Biome SHAMEFUL_PLAINS = GNSBiomeProv.Makers.SHAMEFUL_PLAINS;
    public static final Biome WASTED_FOREST = GNSBiomeProv.Makers.WASTED_FOREST;
    public static final Biome HOPEFUL_FIELDS = GNSBiomeProv.Makers.HOPEFUL_FIELDS;

    public static void init(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        GNSDimensions.initNoiseSettings();
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "sleepy_hills", SLEEPY_HILLS);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "dreamy_forest", DREAMY_FOREST);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "good_dream_plains", GOOD_DREAM_PLAINS);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "lollipop_lands", LOLLIPOP_LANDS);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "nightmare_hills", NIGHTMARE_HILLS);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "shameful_plains", SHAMEFUL_PLAINS);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "wasted_forest", WASTED_FOREST);
        GNSBiomes.register((IForgeRegistry<Biome>)registry, "hopeful_fields", HOPEFUL_FIELDS);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"dream_multi_noise", DreamBiomeProvider.dreamProviderCodec);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"nightmare_multi_noise", NightmareBiomeProvider.nightmareProviderCodec);
    }

    private static void register(IForgeRegistry<Biome> registryIn, String keyIn, Biome biomeIn) {
        GNSRegistry.register(registryIn, keyIn, biomeIn);
    }

    public static class Keys {
        public static final RegistryKey<Biome> SLEEPY_HILLS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("sleepy_hills"));
        public static final RegistryKey<Biome> DREAMY_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("dreamy_forest"));
        public static final RegistryKey<Biome> GOOD_DREAM_PLAINS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("good_dream_plains"));
        public static final RegistryKey<Biome> LOLLIPOP_LANDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("lollipop_lands"));
        public static final RegistryKey<Biome> NIGHTMARE_HILLS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("nightmare_hills"));
        public static final RegistryKey<Biome> SHAMEFUL_PLAINS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("shameful_plains"));
        public static final RegistryKey<Biome> WASTED_FOREST = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("wasted_forest"));
        public static final RegistryKey<Biome> HOPEFUL_FIELDS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)GoodNightSleep.locate("hopeful_fields"));
        public static final List<RegistryKey<Biome>> DREAM_BIOMES = ImmutableList.of(SLEEPY_HILLS, DREAMY_FOREST, GOOD_DREAM_PLAINS, HOPEFUL_FIELDS, LOLLIPOP_LANDS);
        public static final List<RegistryKey<Biome>> NIGHTMARE_BIOMES = ImmutableList.of(NIGHTMARE_HILLS, SHAMEFUL_PLAINS, WASTED_FOREST);

        public static RegistryKey<Biome> getKeyFromBiome(World world, Biome biomeIn) {
            Optional biome = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biomeIn);
            if (biome.isPresent()) {
                return (RegistryKey)biome.get();
            }
            return null;
        }
    }

    public static class SurfaceBuilders {
        public static final SurfaceBuilderConfig DREAM_GRASS_DIRT_GRAVEL_CONFIG = new SurfaceBuilderConfig(GNSBlocks.dream_grass_block.func_176223_P(), GNSBlocks.dream_dirt.func_176223_P(), Blocks.field_150351_n.func_176223_P());
        public static final SurfaceBuilderConfig NIGHTMARE_GRASS_DIRT_GRAVEL_CONFIG = new SurfaceBuilderConfig(GNSBlocks.nightmare_grass_block.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150351_n.func_176223_P());
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> DREAM_GRASS_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)DREAM_GRASS_DIRT_GRAVEL_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> NIGHTMARE_GRASS_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)NIGHTMARE_GRASS_DIRT_GRAVEL_CONFIG);
    }
}

