/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSRegistry;
import com.legacy.goodnightsleep.world.carver.GNSCanyonWorldCarver;
import com.legacy.goodnightsleep.world.carver.GNSCaveWorldCarver;
import com.legacy.goodnightsleep.world.dream.features.DreamSpongeFeature;
import com.legacy.goodnightsleep.world.dream.features.FatHopeMushroomFeature;
import com.legacy.goodnightsleep.world.dream.features.TallHopeMushroomFeature;
import com.legacy.goodnightsleep.world.general_features.DreamScatteredPlantFeature;
import com.legacy.goodnightsleep.world.nightmare.features.NetherSplashFeature;
import com.mojang.serialization.Codec;
import java.util.OptionalInt;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class GNSFeatures {
    public static final Feature<BigMushroomFeatureConfig> TALL_HOPE_MUSHROOM = new TallHopeMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
    public static final Feature<BigMushroomFeatureConfig> FAT_HOPE_MUSHROOM = new FatHopeMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
    public static final Feature<NoFeatureConfig> DREAM_SPONGE = new DreamSpongeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<NoFeatureConfig> SCATTERED_PRESENTS = new DreamScatteredPlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, GNSBlocks.present.func_176223_P());
    public static final Feature<NoFeatureConfig> NETHER_SPLASH = new NetherSplashFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<NoFeatureConfig> SCATTERED_PUMPKINS = new DreamScatteredPlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, Blocks.field_150423_aK.func_176223_P());
    public static final RuleTest DELUSION_RULE_TEST = new BlockMatchRuleTest(GNSBlocks.delusion_stone);
    public static final BlockClusterFeatureConfig DREAM_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dream_grass.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig NIGHTMARE_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.nightmare_grass.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig DREAM_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(GNSBlocks.cyan_flower.func_176223_P(), 1).func_227407_a_(GNSBlocks.orange_flower.func_176223_P(), 1).func_227407_a_(GNSBlocks.lollipop_bush.func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig LOLLIPOP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.lollipop_bush.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig PRICKLY_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.prickly_nightmare_grass.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig DEAD_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(GNSBlocks.dead_flower.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig HOPE_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.hope_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DESPAIR_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.despair_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        GNSRegistry.register(event.getRegistry(), "tall_hope_mushroom", TALL_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "fat_hope_mushroom", FAT_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "dream_sponge", DREAM_SPONGE);
        GNSRegistry.register(event.getRegistry(), "scattered_presents", SCATTERED_PRESENTS);
        GNSRegistry.register(event.getRegistry(), "nether_splash", NETHER_SPLASH);
        GNSRegistry.register(event.getRegistry(), "scattered_pumpkins", SCATTERED_PUMPKINS);
        Configured.init();
    }

    public static void addDreamOres(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_DIRT_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_COAL_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_CANDY_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_RAINBOW_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_POSITITE_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_LAPIS_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.DREAM_GLOWSTONE_ORE);
    }

    public static void addDreamTrees(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HILLS_DREAM_TREE);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HILLS_CANDY_TREE);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HILLS_DIAMOND_TREE);
    }

    public static void addScatteredDreamFeatures(BiomeGenerationSettings.Builder biomeIn) {
        GNSFeatures.addDreamSponges(biomeIn);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SCATTERED_PRESENTS);
    }

    public static void addDreamSponges(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.SCATTERED_SPONGE);
    }

    public static void addHugeHopeMushrooms(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HUGE_HOPE_MUSHROOM);
    }

    public static void addHopeMushroomFields(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.FIELDS_HOPE_MUSHROOM);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.FIELDS_LARGER_HOPE_MUSHROOM);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.FIELDS_VERY_LARGE_HOPE_MUSHROOM);
    }

    public static void addNightmareOres(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_COAL_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_GRAVEL_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_COAL_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_NECRUM_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_ZITRITE_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_IRON_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_NEGATITE_ORE);
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.NIGHTMARE_LAPIS_ORE);
    }

    public static void addNightmareTrees(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HILLS_DEAD_TREE);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HILLS_BLOOD_TREE);
    }

    public static void addScatteredNightmareFeatures(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.NETHER_SPLASH);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SCATTERED_PUMPKINS);
    }

    public static void addHugeDespairMushrooms(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HUGE_DESPAIR_MUSHROOM);
    }

    public static void addCarvers(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242512_a(GenerationStage.Carving.AIR, Configured.DELUSION_CAVE_CARVER);
        biomeIn.func_242512_a(GenerationStage.Carving.AIR, Configured.DELUSION_CANYON_CARVER);
    }

    public static void addMushrooms(BiomeLoadingEvent eventIn) {
        if (eventIn.getName().toString().contains("good_nights_sleep") || eventIn.getCategory() == Biome.Category.THEEND || eventIn.getCategory() == Biome.Category.NONE) {
            return;
        }
        if (eventIn.getCategory() == Biome.Category.NETHER) {
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.NETHER_HOPE_MUSHROOM_PATCH);
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.NETHER_DESPAIR_MUSHROOM_PATCH);
        } else {
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.HOPE_MUSHROOM_PATCH);
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DESPAIR_MUSHROOM_PATCH);
        }
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> createBasicTree(BlockState log, BlockState leaves, int height) {
        return GNSFeatures.createBasicTree(log, leaves, height, 2);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> createBasicTree(BlockState log, BlockState leaves, int height, int randHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), (BlockStateProvider)new SimpleBlockStateProvider(leaves), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(height, randHeight, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static class Configured {
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_DREAM_TREE = GNSFeatures.createBasicTree(GNSBlocks.dream_log.func_176223_P(), GNSBlocks.dream_leaves.func_176223_P(), 4, 1);
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_CANDY_TREE = GNSFeatures.createBasicTree(GNSBlocks.white_log.func_176223_P(), GNSBlocks.candy_leaves.func_176223_P(), 5);
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_LARGE_CANDY_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.white_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.candy_leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 4), (AbstractTrunkPlacer)new StraightTrunkPlacer(7, 3, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_DIAMOND_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dream_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.diamond_leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_DEAD_TREE = GNSFeatures.createBasicTree(GNSBlocks.dead_log.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 5);
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_BLOOD_TREE = GNSFeatures.createBasicTree(GNSBlocks.blood_log.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 5);
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_LARGE_DEAD_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dead_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
        public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BASE_LARGE_BLOOD_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.blood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(8))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> BASE_HUGE_HOPE_MUSHROOM = Feature.field_202318_R.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 2));
        public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> BASE_HUGE_DESPAIR_MUSHROOM = Feature.field_202319_S.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.despair_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 3));
        public static final ConfiguredFeature<?, ?> TALLER_HOPE_MUSHROOM = TALL_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 2));
        public static final ConfiguredFeature<?, ?> SLIGHTLY_LARGER_HOPE_MUSHROOM = TALL_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 3));
        public static final ConfiguredFeature<?, ?> VERY_LARGE_HOPE_MUSHROOM = FAT_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 5));
        public static final ConfiguredFeature<?, ?> HOPE_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(8)));
        public static final ConfiguredFeature<?, ?> DESPAIR_MUSHROOM_PATCH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(4)));
        public static final ConfiguredFeature<?, ?> NETHER_HOPE_MUSHROOM_PATCH = (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_242733_d(128)).func_242729_a(8);
        public static final ConfiguredFeature<?, ?> NETHER_DESPAIR_MUSHROOM_PATCH = (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_242733_d(128)).func_242729_a(4);
        public static final ConfiguredFeature<?, ?> HILLS_DREAM_TREE = BASE_DREAM_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        public static final ConfiguredFeature<?, ?> HILLS_CANDY_TREE = BASE_CANDY_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        public static final ConfiguredFeature<?, ?> HILLS_DIAMOND_TREE = BASE_DIAMOND_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1)));
        public static final ConfiguredFeature<?, ?> DREAM_DIRT_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.dream_dirt.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10);
        public static final ConfiguredFeature<?, ?> DREAM_CANDY_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.candy_ore.func_176223_P(), 15)).func_242733_d(64)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> DREAM_RAINBOW_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.rainbow_ore.func_176223_P(), 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> DREAM_POSITITE_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.positite_ore.func_176223_P(), 8)).func_242733_d(16)).func_242728_a()).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> DREAM_COAL_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.coal_ore.func_176223_P(), 17)).func_242733_d(128)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> DREAM_LAPIS_ORE = (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, GNSBlocks.lapis_ore.func_176223_P(), 7)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(16, 16))).func_242728_a();
        public static final ConfiguredFeature<?, ?> DREAM_GLOWSTONE_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DELUSION_RULE_TEST, Blocks.field_150426_aN.func_176223_P(), 8)).func_242733_d(7)).func_242728_a()).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> SCATTERED_PRESENTS = (ConfiguredFeature)SCATTERED_PRESENTS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(32);
        public static final ConfiguredFeature<?, ?> SCATTERED_SPONGE = (ConfiguredFeature)DREAM_SPONGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> HUGE_HOPE_MUSHROOM = BASE_HUGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1)));
        public static final ConfiguredFeature<?, ?> FIELDS_HOPE_MUSHROOM = BASE_HUGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1)));
        public static final ConfiguredFeature<?, ?> FIELDS_LARGER_HOPE_MUSHROOM = SLIGHTLY_LARGER_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.0f, 2)));
        public static final ConfiguredFeature<?, ?> FIELDS_VERY_LARGE_HOPE_MUSHROOM = VERY_LARGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> NIGHTMARE_DIRT_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150346_d.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_GRAVEL_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150351_n.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(8);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_NECRUM_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.necrum_ore.func_176223_P(), 15)).func_242733_d(128)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_ZITRITE_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.zitrite_ore.func_176223_P(), 8)).func_242733_d(32)).func_242728_a()).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_NEGATITE_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.negatite_ore.func_176223_P(), 5)).func_242733_d(16)).func_242728_a()).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_COAL_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150365_q.func_176223_P(), 17)).func_242733_d(128)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_IRON_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150366_p.func_176223_P(), 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_LAPIS_ORE = (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150369_x.func_176223_P(), 7)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(16, 16))).func_242728_a();
        public static final ConfiguredFeature<?, ?> HILLS_DEAD_TREE = BASE_LARGE_DEAD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1)));
        public static final ConfiguredFeature<?, ?> HILLS_BLOOD_TREE = BASE_BLOOD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        public static final ConfiguredFeature<?, ?> NETHER_SPLASH = (ConfiguredFeature)NETHER_SPLASH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> SCATTERED_PUMPKINS = (ConfiguredFeature)SCATTERED_PUMPKINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(35);
        public static final ConfiguredFeature<?, ?> HUGE_DESPAIR_MUSHROOM = BASE_HUGE_DESPAIR_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        public static final ConfiguredFeature<?, ?> PLAINS_DIAMOND_TREE = BASE_DIAMOND_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> PLAINS_HOPE_MUSHROOM = BASE_HUGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> FOREST_DREAM_TREE = BASE_DREAM_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.1f, 5)));
        public static final ConfiguredFeature<?, ?> FOREST_CANDY_TREE = BASE_CANDY_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.8f, 1)));
        public static final ConfiguredFeature<?, ?> LANDS_CANDY_TREE = BASE_LARGE_CANDY_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.0f, 5)));
        public static final ConfiguredFeature<?, ?> LANDS_DREAM_TREE = BASE_DREAM_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1)));
        public static final ConfiguredFeature<?, ?> PLAINS_BLOOD_TREE = BASE_LARGE_BLOOD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1)));
        public static final ConfiguredFeature<?, ?> PLAINS_DESPAIR_MUSHROOM = BASE_HUGE_DESPAIR_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> FOREST_DEAD_TREE = BASE_DEAD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.1f, 5)));
        public static final ConfiguredFeature<?, ?> FOREST_BLOOD_TREE = BASE_LARGE_BLOOD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.8f, 1)));
        public static final ConfiguredFeature<?, ?> NOISE_BASED_DREAM_GRASS = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DREAM_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10)));
        public static final ConfiguredFeature<?, ?> NOISE_BASED_NIGHTMARE_GRASS = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)NIGHTMARE_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10)));
        public static final ConfiguredFeature<?, ?> DREAM_FLOWERS_5 = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DREAM_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_FLOWERS_5 = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DEAD_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> DREAM_LOLLIPOPS_20 = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)LOLLIPOP_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> DREAM_MUSHROOMS_25 = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(25);
        public static final ConfiguredFeature<?, ?> NIGHTMARE_GRASS_5 = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)NIGHTMARE_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> PRICKLY_NIGHTMARE_GRASS_1 = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PRICKLY_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> PRICKLY_NIGHTMARE_GRASS_2 = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PRICKLY_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(2);
        public static final ConfiguredCarver<?> DELUSION_CAVE_CARVER = Carvers.DELUSION_CAVE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.14285715f));
        public static final ConfiguredCarver<?> DELUSION_CANYON_CARVER = Carvers.DELUSION_CANYON_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f));

        public static void init() {
            Configured.register("dream_tree", BASE_DREAM_TREE);
            Configured.register("candy_tree", BASE_CANDY_TREE);
            Configured.register("large_candy_tree", BASE_LARGE_CANDY_TREE);
            Configured.register("diamond_tree", BASE_DIAMOND_TREE);
            Configured.register("dead_tree", BASE_DEAD_TREE);
            Configured.register("blood_tree", BASE_BLOOD_TREE);
            Configured.register("large_dead_tree", BASE_LARGE_DEAD_TREE);
            Configured.register("large_blood_tree", BASE_LARGE_BLOOD_TREE);
            Configured.register("taller_hope_mushroom", TALLER_HOPE_MUSHROOM);
            Configured.register("slightly_larger_hope_mushroom", SLIGHTLY_LARGER_HOPE_MUSHROOM);
            Configured.register("very_large_hope_mushroom", VERY_LARGE_HOPE_MUSHROOM);
            Configured.register("hope_mushroom_patch", HOPE_MUSHROOM_PATCH);
            Configured.register("despair_mushroom_patch", DESPAIR_MUSHROOM_PATCH);
            Configured.register("nether_hope_mushroom_patch", NETHER_HOPE_MUSHROOM_PATCH);
            Configured.register("nether_despair_mushroom_patch", NETHER_DESPAIR_MUSHROOM_PATCH);
            Configured.register("hills_dream_tree", HILLS_DREAM_TREE);
            Configured.register("hills_candy_tree", HILLS_CANDY_TREE);
            Configured.register("hills_diamond_tree", HILLS_DIAMOND_TREE);
            Configured.register("dream_dirt_ore", DREAM_DIRT_ORE);
            Configured.register("dream_candy_ore", DREAM_CANDY_ORE);
            Configured.register("dream_rainbow_ore", DREAM_RAINBOW_ORE);
            Configured.register("dream_positite_ore", DREAM_POSITITE_ORE);
            Configured.register("dream_coal_ore", DREAM_COAL_ORE);
            Configured.register("dream_lapis_ore", DREAM_LAPIS_ORE);
            Configured.register("dream_glowstone_ore", DREAM_GLOWSTONE_ORE);
            Configured.register("scattered_presents", SCATTERED_PRESENTS);
            Configured.register("scattered_sponge", SCATTERED_SPONGE);
            Configured.register("huge_hope_mushroom", HUGE_HOPE_MUSHROOM);
            Configured.register("fields_hope_mushroom", FIELDS_HOPE_MUSHROOM);
            Configured.register("fields_larger_hope_mushroom", FIELDS_LARGER_HOPE_MUSHROOM);
            Configured.register("fields_very_large_hope_mushroom", FIELDS_VERY_LARGE_HOPE_MUSHROOM);
            Configured.register("nightmare_dirt_ore", NIGHTMARE_DIRT_ORE);
            Configured.register("nightmare_gravel_ore", NIGHTMARE_GRAVEL_ORE);
            Configured.register("nightmare_necrum_ore", NIGHTMARE_NECRUM_ORE);
            Configured.register("nightmare_zitrite_ore", NIGHTMARE_ZITRITE_ORE);
            Configured.register("nightmare_negatite_ore", NIGHTMARE_NEGATITE_ORE);
            Configured.register("nightmare_coal_ore", NIGHTMARE_COAL_ORE);
            Configured.register("nightmare_iron_ore", NIGHTMARE_IRON_ORE);
            Configured.register("nightmare_lapis_ore", NIGHTMARE_LAPIS_ORE);
            Configured.register("hills_dead_tree", HILLS_DEAD_TREE);
            Configured.register("hills_blood_tree", HILLS_BLOOD_TREE);
            Configured.register("nether_splash", NETHER_SPLASH);
            Configured.register("scattered_pumpkins", SCATTERED_PUMPKINS);
            Configured.register("huge_despair_mushroom", HUGE_DESPAIR_MUSHROOM);
            Configured.register("plains_diamond_tree", PLAINS_DIAMOND_TREE);
            Configured.register("plains_hope_mushroom", PLAINS_HOPE_MUSHROOM);
            Configured.register("forest_dream_tree", FOREST_DREAM_TREE);
            Configured.register("forest_candy_tree", FOREST_CANDY_TREE);
            Configured.register("lands_candy_tree", LANDS_CANDY_TREE);
            Configured.register("lands_dream_tree", LANDS_DREAM_TREE);
            Configured.register("plains_blood_tree", PLAINS_BLOOD_TREE);
            Configured.register("plains_despair_mushroom", PLAINS_DESPAIR_MUSHROOM);
            Configured.register("forest_dead_tree", FOREST_DEAD_TREE);
            Configured.register("forest_blood_tree", FOREST_BLOOD_TREE);
            Configured.register("noise_based_dream_grass", NOISE_BASED_DREAM_GRASS);
            Configured.register("noise_based_nightmare_grass", NOISE_BASED_NIGHTMARE_GRASS);
            Configured.register("dream_flowers_5", DREAM_FLOWERS_5);
            Configured.register("nightmare_flowers_5", NIGHTMARE_FLOWERS_5);
            Configured.register("dream_lollipops_20", DREAM_LOLLIPOPS_20);
            Configured.register("dream_mushrooms_25", DREAM_MUSHROOMS_25);
            Configured.register("nightmare_grass_5", NIGHTMARE_GRASS_5);
            Configured.register("prickly_nightmare_grass_1", PRICKLY_NIGHTMARE_GRASS_1);
            Configured.register("prickly_nightmare_grass_2", PRICKLY_NIGHTMARE_GRASS_2);
        }

        public static void initCarvers() {
            Configured.registerCarver("delusion_cave_carver", DELUSION_CAVE_CARVER);
            Configured.registerCarver("delusion_canyon_carver", DELUSION_CANYON_CARVER);
        }

        private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String nameIn, ConfiguredFeature<FC, ?> featureIn) {
            return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)nameIn, featureIn);
        }

        private static <C extends ICarverConfig> ConfiguredCarver<C> registerCarver(String nameIn, ConfiguredCarver<C> featureIn) {
            return (ConfiguredCarver)Registry.func_218325_a((Registry)WorldGenRegistries.field_243652_d, (String)nameIn, featureIn);
        }
    }

    public static class Carvers {
        public static final WorldCarver<ProbabilityConfig> DELUSION_CAVE_CARVER = new GNSCaveWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256);
        public static final WorldCarver<ProbabilityConfig> DELUSION_CANYON_CARVER = new GNSCanyonWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);

        public static void init(RegistryEvent.Register<WorldCarver<?>> event) {
            GNSRegistry.register(event.getRegistry(), "delusion_cave_carver", DELUSION_CAVE_CARVER);
            GNSRegistry.register(event.getRegistry(), "delusion_canyon_carver", DELUSION_CANYON_CARVER);
            Configured.initCarvers();
        }
    }
}

