/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world;

import com.legacy.goodnightsleep.client.GNSClientEvents;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ISkyRenderHandler;

public class DreamSkyRenderer
implements ISkyRenderHandler {
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private TextureManager textureManager;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private final VertexFormat skyVertexFormat;
    public static final DreamSkyRenderer INSTANCE = new DreamSkyRenderer();

    public DreamSkyRenderer() {
        this.textureManager = Minecraft.func_71410_x().field_71446_o;
        this.skyVertexFormat = DefaultVertexFormats.field_181705_e;
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    public float sunriseColors(long timeIn) {
        double d0 = MathHelper.func_181162_h((double)((double)timeIn / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public void render(int ticks, float partialTicks, MatrixStack matrixStackIn, ClientWorld world, Minecraft mc) {
        RenderSystem.disableTexture();
        Vector3d Vector3d2 = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)Vector3d2.field_72450_a;
        float f1 = (float)Vector3d2.field_72448_b;
        float f2 = (float)Vector3d2.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.skyVBO.func_177359_a();
        this.skyVertexFormat.func_227892_a_(0L);
        this.skyVBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.skyVertexFormat.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.func_239132_a_().func_230492_a_(GNSClientEvents.calculateSunAngle(world.func_82737_E(), partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStackIn.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStackIn.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(GNSClientEvents.calculateSunAngle(world.func_82737_E(), partialTicks) * 360.0f));
        Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.textureManager.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 20.0f;
        this.textureManager.func_110577_a(MOON_PHASES_TEXTURES);
        int k = world.func_242414_af();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, f12).func_225583_a_(f15, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, f12).func_225583_a_(f13, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, -f12).func_225583_a_(f13, f14).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, -f12).func_225583_a_(f15, f14).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f * f11;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.starVBO.func_177359_a();
            this.skyVertexFormat.func_227892_a_(0L);
            this.starVBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.skyVertexFormat.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStackIn.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72912_H().func_239159_f_();
        if (d0 < 0.0) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 12.0, 0.0);
            this.sky2VBO.func_177359_a();
            this.skyVertexFormat.func_227892_a_(0L);
            this.sky2VBO.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.skyVertexFormat.func_227895_d_();
            matrixStackIn.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new VertexBuffer(this.skyVertexFormat);
        this.renderStars(bufferbuilder);
        bufferbuilder.func_178977_d();
        this.starVBO.func_227875_a_(bufferbuilder);
    }

    private void renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_225582_a_(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.sky2VBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, -16.0f, true);
        bufferbuilder.func_178977_d();
        this.sky2VBO.func_227875_a_(bufferbuilder);
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        this.skyVBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, 16.0f, false);
        bufferbuilder.func_178977_d();
        this.skyVBO.func_227875_a_(bufferbuilder);
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }
}

