/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.biome_provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.registry.GNSBiomes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DreamBiomeProvider
extends BiomeProvider {
    private static final Noise defaultNoise = new Noise(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<DreamBiomeProvider> field_235262_e_ = RecordCodecBuilder.mapCodec(p_242602_0_ -> p_242602_0_.group((App)Codec.LONG.fieldOf("seed").forGetter(p_235286_0_ -> p_235286_0_.seed), (App)RecordCodecBuilder.create(p_235282_0_ -> p_235282_0_.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.field_235051_b_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)p_235282_0_, Pair::of)).listOf().fieldOf("biomes").forGetter(p_235284_0_ -> p_235284_0_.biomes), (App)Noise.field_242609_a.fieldOf("temperature_noise").forGetter(p_242608_0_ -> p_242608_0_.temperatureNoise), (App)Noise.field_242609_a.fieldOf("humidity_noise").forGetter(p_242607_0_ -> p_242607_0_.humidityNoise), (App)Noise.field_242609_a.fieldOf("altitude_noise").forGetter(p_242606_0_ -> p_242606_0_.altitudeNoise), (App)Noise.field_242609_a.fieldOf("weirdness_noise").forGetter(p_242604_0_ -> p_242604_0_.weirdnessNoise)).apply((Applicative)p_242602_0_, DreamBiomeProvider::new));
    public static final Codec<DreamBiomeProvider> dreamProviderCodec = Codec.mapEither(DreamBuilder.field_242624_a, field_235262_e_).xmap(p_235277_0_ -> (DreamBiomeProvider)((Object)((Object)p_235277_0_.map(DreamBuilder::func_242635_d, Function.identity()))), p_235275_0_ -> p_235275_0_.createDreamBuilder().map(Either::left).orElseGet(() -> Either.right((Object)p_235275_0_))).codec();
    private final Noise temperatureNoise;
    private final Noise humidityNoise;
    private final Noise altitudeNoise;
    private final Noise weirdnessNoise;
    private final MaxMinNoiseMixer field_235264_g_;
    private final MaxMinNoiseMixer field_235265_h_;
    private final MaxMinNoiseMixer field_235266_i_;
    private final MaxMinNoiseMixer field_235267_j_;
    private final List<Pair<Biome.Attributes, Supplier<Biome>>> biomes;
    private final boolean field_235269_l_;
    private final long seed;
    private final Optional<Pair<Registry<Biome>, DreamPreset>> biomePreset;

    public DreamBiomeProvider(long seedIn, List<Pair<Biome.Attributes, Supplier<Biome>>> biomesIn, Optional<Pair<Registry<Biome>, DreamPreset>> presetIn) {
        this(seedIn, biomesIn, defaultNoise, defaultNoise, defaultNoise, defaultNoise, presetIn);
    }

    public DreamBiomeProvider(long seedIn, List<Pair<Biome.Attributes, Supplier<Biome>>> biomesIn, Noise tempNoiseIn, Noise humidityNoiseIn, Noise altitudeNoiseIn, Noise weirdnessNoiseIn) {
        this(seedIn, biomesIn, tempNoiseIn, humidityNoiseIn, altitudeNoiseIn, weirdnessNoiseIn, Optional.empty());
    }

    public DreamBiomeProvider(long seedIn, List<Pair<Biome.Attributes, Supplier<Biome>>> biomesIn, Noise tempNoiseIn, Noise humidityNoiseIn, Noise altitudeNoiseIn, Noise weirdnessNoiseIn, Optional<Pair<Registry<Biome>, DreamPreset>> presetIn) {
        super(biomesIn.stream().map(Pair::getSecond));
        this.seed = seedIn;
        this.biomePreset = presetIn;
        this.temperatureNoise = tempNoiseIn;
        this.humidityNoise = humidityNoiseIn;
        this.altitudeNoise = altitudeNoiseIn;
        this.weirdnessNoise = weirdnessNoiseIn;
        this.field_235264_g_ = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seedIn), (int)tempNoiseIn.func_242612_a(), (DoubleList)tempNoiseIn.func_242614_b());
        this.field_235265_h_ = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seedIn + 1L), (int)humidityNoiseIn.func_242612_a(), (DoubleList)humidityNoiseIn.func_242614_b());
        this.field_235266_i_ = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seedIn + 2L), (int)altitudeNoiseIn.func_242612_a(), (DoubleList)altitudeNoiseIn.func_242614_b());
        this.field_235267_j_ = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seedIn + 3L), (int)weirdnessNoiseIn.func_242612_a(), (DoubleList)weirdnessNoiseIn.func_242614_b());
        this.biomes = biomesIn;
        this.field_235269_l_ = false;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return dreamProviderCodec;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new DreamBiomeProvider(seed, this.biomes, this.temperatureNoise, this.humidityNoise, this.altitudeNoise, this.weirdnessNoise, this.biomePreset);
    }

    private Optional<DreamBuilder> createDreamBuilder() {
        return this.biomePreset.map(p_242601_1_ -> new DreamBuilder((DreamPreset)p_242601_1_.getSecond(), (Registry)p_242601_1_.getFirst(), this.seed));
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int i = this.field_235269_l_ ? y : 0;
        Biome.Attributes biome$attributes = new Biome.Attributes((float)this.field_235264_g_.func_237211_a_((double)x, (double)i, (double)z), (float)this.field_235265_h_.func_237211_a_((double)x, (double)i, (double)z), (float)this.field_235266_i_.func_237211_a_((double)x, (double)i, (double)z), (float)this.field_235267_j_.func_237211_a_((double)x, (double)i, (double)z), 0.0f);
        return this.biomes.stream().min(Comparator.comparing(attributeBiomePair -> Float.valueOf(((Biome.Attributes)attributeBiomePair.getFirst()).func_235110_a_(biome$attributes)))).map(Pair::getSecond).map(Supplier::get).orElse(BiomeRegistry.field_244201_b);
    }

    public boolean func_235280_b_(long p_235280_1_) {
        return this.seed == p_235280_1_ && this.biomePreset.isPresent() && Objects.equals(this.biomePreset.get().getSecond(), DreamPreset.dreamPreset);
    }

    public static class DreamPreset {
        private static final Map<ResourceLocation, DreamPreset> biomeMap = Maps.newHashMap();
        public static final DreamPreset dreamPreset = new DreamPreset(GoodNightSleep.locate("good_dream"), (Function3<DreamPreset, Registry<Biome>, Long, DreamBiomeProvider>)((Function3)(preset, biomeList, seedIn) -> new DreamBiomeProvider((long)seedIn, (List<Pair<Biome.Attributes, Supplier<Biome>>>)ImmutableList.of((Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)biomeList.func_243576_d(GNSBiomes.Keys.SLEEPY_HILLS)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.1f, 0.0f), () -> (Biome)biomeList.func_243576_d(GNSBiomes.Keys.DREAMY_FOREST)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.1f, 0.0f, 0.0f, 0.0f), () -> (Biome)biomeList.func_243576_d(GNSBiomes.Keys.GOOD_DREAM_PLAINS)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.1f, 0.0f, 0.0f), () -> (Biome)biomeList.func_243576_d(GNSBiomes.Keys.LOLLIPOP_LANDS))), Optional.of(Pair.of((Object)biomeList, (Object)preset)))));
        private final ResourceLocation field_235290_d_;
        private final Function3<DreamPreset, Registry<Biome>, Long, DreamBiomeProvider> field_235291_e_;

        public DreamPreset(ResourceLocation p_i241955_1_, Function3<DreamPreset, Registry<Biome>, Long, DreamBiomeProvider> p_i241955_2_) {
            this.field_235290_d_ = p_i241955_1_;
            this.field_235291_e_ = p_i241955_2_;
            biomeMap.put(p_i241955_1_, this);
        }

        public DreamBiomeProvider func_242619_a(Registry<Biome> p_242619_1_, long p_242619_2_) {
            return (DreamBiomeProvider)((Object)this.field_235291_e_.apply((Object)this, p_242619_1_, (Object)p_242619_2_));
        }

        public ResourceLocation getName() {
            return this.field_235290_d_;
        }
    }

    static class Noise {
        private final int field_242610_b;
        private final DoubleList field_242611_c;
        public static final Codec<Noise> field_242609_a = RecordCodecBuilder.create(p_242613_0_ -> p_242613_0_.group((App)Codec.INT.fieldOf("firstOctave").forGetter(Noise::func_242612_a), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(Noise::func_242614_b)).apply((Applicative)p_242613_0_, Noise::new));

        public Noise(int p_i241954_1_, List<Double> p_i241954_2_) {
            this.field_242610_b = p_i241954_1_;
            this.field_242611_c = new DoubleArrayList(p_i241954_2_);
        }

        public int func_242612_a() {
            return this.field_242610_b;
        }

        public DoubleList func_242614_b() {
            return this.field_242611_c;
        }
    }

    static final class DreamBuilder {
        public static final MapCodec<DreamBuilder> field_242624_a = RecordCodecBuilder.mapCodec(p_242630_0_ -> p_242630_0_.group((App)ResourceLocation.field_240908_a_.flatXmap(location -> Optional.ofNullable(DreamPreset.biomeMap.get(location)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + location))), p_242629_0_ -> DataResult.success((Object)p_242629_0_.getName())).fieldOf("preset").stable().forGetter(DreamBuilder::func_242628_a), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(DreamBuilder::func_242632_b), (App)Codec.LONG.fieldOf("seed").stable().forGetter(DreamBuilder::func_242634_c)).apply((Applicative)p_242630_0_, p_242630_0_.stable(DreamBuilder::new)));
        private final DreamPreset field_242625_b;
        private final Registry<Biome> field_242626_c;
        private final long field_242627_d;

        private DreamBuilder(DreamPreset p_i241956_1_, Registry<Biome> p_i241956_2_, long p_i241956_3_) {
            this.field_242625_b = p_i241956_1_;
            this.field_242626_c = p_i241956_2_;
            this.field_242627_d = p_i241956_3_;
        }

        public DreamPreset func_242628_a() {
            return this.field_242625_b;
        }

        public Registry<Biome> func_242632_b() {
            return this.field_242626_c;
        }

        public long func_242634_c() {
            return this.field_242627_d;
        }

        public DreamBiomeProvider func_242635_d() {
            return this.field_242625_b.func_242619_a(this.field_242626_c, this.field_242627_d);
        }
    }
}

