/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus;

import com.mojang.brigadier.CommandDispatcher;
import de.cas_ual_ty.guncus.IProxy;
import de.cas_ual_ty.guncus.client.ProxyClient;
import de.cas_ual_ty.guncus.command.CommandGunCus;
import de.cas_ual_ty.guncus.itemgroup.ItemGroupGunCus;
import de.cas_ual_ty.guncus.network.MessageBulletMaker;
import de.cas_ual_ty.guncus.network.MessageGunMaker;
import de.cas_ual_ty.guncus.network.MessageHitmarker;
import de.cas_ual_ty.guncus.network.MessageShoot;
import de.cas_ual_ty.guncus.registries.GunCusItems;
import de.cas_ual_ty.guncus.registries.GunCusPointOfInterestTypes;
import de.cas_ual_ty.guncus.registries.GunCusVillagerProfessions;
import de.cas_ual_ty.guncus.server.ProxyServer;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="guncus")
public class GunCus {
    public static final String MOD_ID = "guncus";
    public static final String PROTOCOL_VERSION = "1";
    public static GunCus instance;
    public static IProxy proxy;
    public static SimpleChannel channel;
    public static final boolean FULL_CREATIVE_TABS = true;
    public static final ItemGroupGunCus ITEM_GROUP_GUN_CUS;

    public GunCus() {
        instance = this;
        proxy = (IProxy)DistExecutor.runForDist(() -> ProxyClient::new, () -> ProxyServer::new);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
        proxy.registerModEventListeners(bus);
        bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::serverStarting);
        bus.addListener(this::villagerTrades);
        bus.addListener(this::wandererTrades);
        proxy.registerForgeEventListeners(bus);
    }

    public void init(FMLCommonSetupEvent event) {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        channel.registerMessage(0, MessageShoot.class, MessageShoot::encode, MessageShoot::decode, MessageShoot::handle);
        channel.registerMessage(1, MessageHitmarker.class, MessageHitmarker::encode, MessageHitmarker::decode, MessageHitmarker::handle);
        channel.registerMessage(2, MessageGunMaker.class, MessageGunMaker::encode, MessageGunMaker::decode, MessageGunMaker::handle);
        channel.registerMessage(3, MessageBulletMaker.class, MessageBulletMaker::encode, MessageBulletMaker::decode, MessageBulletMaker::handle);
        GunCusUtility.fixPOITypeBlockStates(GunCusPointOfInterestTypes.ARMS_DEALER);
        proxy.init();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        CommandGunCus.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() == GunCusVillagerProfessions.ARMS_DEALER) {
            ((List)event.getTrades().get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 16), new ItemStack((IItemProvider)GunCusItems.GUN_TABLE), 8, 10, 0.0f));
            RandomTradeBuilder.forEachLevel((level, tradeBuild) -> ((List)event.getTrades().get(level.intValue())).add(tradeBuild.build()));
        }
    }

    public void wandererTrades(WandererTradesEvent event) {
        List genericList = event.getGenericTrades();
        RandomTradeBuilder.forEachWanderer(tradeBuild -> genericList.add(tradeBuild.build()));
        List rareList = event.getRareTrades();
        RandomTradeBuilder.forEachWandererRare(tradeBuild -> rareList.add(tradeBuild.build()));
    }

    public static void debug(String s) {
        System.out.println("guncus ----- " + s);
    }

    static {
        ITEM_GROUP_GUN_CUS = new ItemGroupGunCus();
    }
}

