/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import de.cas_ual_ty.guncus.client.ProxyClient;
import net.minecraft.client.MainWindow;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HitmarkerRenderer {
    public static final ResourceLocation HITMARKER_TEXTURE = new ResourceLocation("guncus", "textures/gui/hitmarker.png");
    public static final int HITMARKER_RESET = 4;
    private static int hitmarkerTick = 0;

    public static void addHitmarker() {
        hitmarkerTick = 4;
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null && hitmarkerTick > 0) {
            HitmarkerRenderer.drawHitmarker(event.getWindow());
        }
    }

    public static void drawHitmarker(MainWindow sr) {
        ProxyClient.drawDrawFullscreenImage(HITMARKER_TEXTURE, 1024, 256, sr);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && hitmarkerTick > 0) {
            --hitmarkerTick;
        }
    }
}

