/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.cas_ual_ty.guncus.client.ProxyClient;
import de.cas_ual_ty.guncus.entity.EntityBullet;
import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.item.attachments.Accessory;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LaserRenderer {
    public static final RenderState.TransparencyState LASER_TRANSPARENCY = new RenderState.TransparencyState("laser_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.ShadeModelState SHADE_ENABLED = new RenderState.ShadeModelState(true);
    public static final RenderState.WriteMaskState COLOR_WRITE = new RenderState.WriteMaskState(true, false);
    public static final RenderType LASER_POINT = RenderType.func_228633_a_((String)"laser_point", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228727_a_(COLOR_WRITE).func_228726_a_(LASER_TRANSPARENCY).func_228723_a_(SHADE_ENABLED).func_228728_a_(false));
    public static final RenderType LASER_BEAM = RenderType.func_228633_a_((String)"laser_beam", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.empty())).func_228727_a_(COLOR_WRITE).func_228726_a_(LASER_TRANSPARENCY).func_228723_a_(SHADE_ENABLED).func_228728_a_(false));
    private static boolean tmpHitNothing = false;

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        if (ProxyClient.getMC().func_175606_aa() != null) {
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            Vec3d v = renderInfo.func_216785_c();
            matrixStack.func_227861_a_(-v.field_72450_a, -v.field_72448_b, -v.field_72449_c);
            IRenderTypeBuffer.Impl b = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            World world = ProxyClient.getMC().func_175606_aa().field_70170_p;
            float partialTicks = event.getPartialTicks();
            for (PlayerEntity entityPlayer : world.func_217369_A()) {
                Vec3d playerPos = entityPlayer.func_174824_e(partialTicks);
                Vec3d playerLook = entityPlayer.func_70040_Z().func_72432_b();
                if (!entityPlayer.func_70089_S()) continue;
                for (Hand hand : GunCusUtility.HANDS) {
                    IVertexBuilder vb;
                    Accessory accessory = null;
                    ItemStack itemStack = entityPlayer.func_184586_b(hand);
                    if (itemStack.func_77973_b() instanceof ItemGun) {
                        ItemGun gun = (ItemGun)itemStack.func_77973_b();
                        if (gun.isNBTAccessoryTurnedOn(itemStack)) {
                            accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                        }
                    } else if (itemStack.func_77973_b() instanceof Accessory) {
                        accessory = (Accessory)itemStack.func_77973_b();
                    }
                    if (accessory == null || accessory.getLaser() == null) continue;
                    Accessory.Laser laser = accessory.getLaser();
                    Vec3d handOff = LaserRenderer.getOffsetForHand(entityPlayer, hand).func_178787_e(LaserRenderer.getVectorForRotation(entityPlayer.field_70125_A + -345.0f, entityPlayer.field_70177_z));
                    Vec3d start = playerPos.func_178787_e(handOff);
                    Vec3d end = start.func_178787_e(playerLook.func_186678_a(laser.getMaxRange()));
                    end = LaserRenderer.findHit(world, (Entity)entityPlayer, start, end, partialTicks);
                    if (laser.isPoint() && !tmpHitNothing) {
                        vb = b.getBuffer(LASER_POINT);
                        LaserRenderer.renderLaserPoint(vb, matrixStack, laser, start, end);
                        b.func_228462_a_(LASER_POINT);
                    }
                    if (!laser.isBeam()) continue;
                    vb = b.getBuffer(LASER_BEAM);
                    LaserRenderer.renderLaserBeam(vb, matrixStack, laser, start, end);
                    b.func_228462_a_(LASER_BEAM);
                }
            }
            matrixStack.func_227865_b_();
        }
    }

    public static void renderLaserPoint(IVertexBuilder b, MatrixStack m, Accessory.Laser laser, Vec3d start, Vec3d end) {
        Matrix4f matrix = m.func_227866_c_().func_227870_a_();
        float size = 0.05f;
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c + 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a - 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b + 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a + 0.05f, (float)end.field_72448_b - 0.05f, (float)end.field_72449_c - 0.05f).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
    }

    public static void renderLaserBeam(IVertexBuilder b, MatrixStack m, Accessory.Laser laser, Vec3d start, Vec3d end) {
        Matrix4f matrix = m.func_227866_c_().func_227870_a_();
        b.func_227888_a_(matrix, (float)start.field_72450_a, (float)start.field_72448_b, (float)start.field_72449_c).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_227888_a_(matrix, (float)end.field_72450_a, (float)end.field_72448_b, (float)end.field_72449_c).func_227885_a_(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d getOffsetForHandRaw(PlayerEntity entityPlayer, Hand hand) {
        Vec3d vec = LaserRenderer.getVectorForRotation(entityPlayer.field_70125_A + 1.0f, entityPlayer.field_70177_z + 90.0f);
        if (hand == Hand.OFF_HAND) {
            vec = vec.func_186678_a(-1.0);
        }
        if (entityPlayer.field_70125_A >= 89.0f) {
            vec = vec.func_186678_a(-1.0);
        }
        return new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c).func_72432_b().func_186678_a(0.4);
    }

    public static Vec3d getOffsetForHand(PlayerEntity entityPlayer, Hand hand) {
        Vec3d vec = LaserRenderer.getOffsetForHandRaw(entityPlayer, hand);
        return vec.func_178787_e(LaserRenderer.getVectorForRotation(entityPlayer.field_70125_A, entityPlayer.field_70177_z).func_186678_a(0.4));
    }

    public static Vec3d findHit(World world, Entity entity, Vec3d start, Vec3d end, float partialTicks) {
        tmpHitNothing = false;
        BlockRayTraceResult resultBlock = LaserRenderer.findBlockOnPath(world, entity, start, end);
        EntityRayTraceResult resultEntity = LaserRenderer.findEntityOnPath(world, entity, start, end, partialTicks);
        if (resultEntity != null) {
            double rangeEntitySq;
            double rangeBlockSq = resultBlock.func_216347_e().func_72436_e(start);
            if (rangeBlockSq < (rangeEntitySq = resultEntity.func_216347_e().func_72436_e(start))) {
                return resultBlock.func_216347_e();
            }
            return resultEntity.func_216347_e();
        }
        tmpHitNothing = world.func_180495_p(resultBlock.func_216350_a()).func_177230_c() == Blocks.field_150350_a;
        return resultBlock.func_216347_e();
    }

    public static BlockRayTraceResult findBlockOnPath(World world, Entity entity, Vec3d start, Vec3d end) {
        return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
    }

    public static EntityRayTraceResult findEntityOnPath(World world, Entity entity0, Vec3d start, Vec3d end, float partialTicks) {
        EntityRayTraceResult result = null;
        double rangeSq = 0.0;
        for (Entity entity : world.func_175674_a(entity0, GunCusUtility.aabbFromVec3ds(start, end), entity1 -> true)) {
            double currentRangeSq;
            AxisAlignedBB axisalignedbb;
            Optional opt;
            if (entity == null || entity.func_145782_y() == entity0.func_145782_y() || entity instanceof EntityBullet || !(opt = (axisalignedbb = entity.func_174813_aQ().func_191194_a(entity.func_213322_ci().func_186678_a((double)partialTicks)).func_186662_g((double)0.3f)).func_216365_b(start, end)).isPresent() || !((currentRangeSq = start.func_72436_e(entity.func_213303_ch())) < rangeSq) && result != null) continue;
            result = new EntityRayTraceResult(entity, (Vec3d)opt.get());
            rangeSq = currentRangeSq;
        }
        return result;
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null) {
            Vec3d start = new Vec3d(entityPlayer.func_226277_ct_(), entityPlayer.func_226278_cu_() + (double)entityPlayer.func_70047_e(), entityPlayer.func_226281_cx_());
            for (Hand hand : GunCusUtility.HANDS) {
                Accessory accessory;
                ItemStack itemStack = entityPlayer.func_184586_b(hand);
                if (itemStack.func_77973_b() instanceof ItemGun) {
                    ItemGun gun = (ItemGun)itemStack.func_77973_b();
                    accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                } else {
                    accessory = itemStack.func_77973_b() instanceof Accessory ? (Accessory)itemStack.func_77973_b() : (Accessory)EnumAttachmentType.ACCESSORY.getDefault();
                }
                if (accessory.getLaser() == null || !accessory.getLaser().isRangeFinder()) continue;
                Vec3d end = start.func_178787_e(entityPlayer.func_70040_Z().func_72432_b().func_186678_a(accessory.getLaser().getMaxRange()));
                Vec3d hit = LaserRenderer.findHit(entityPlayer.field_70170_p, (Entity)entityPlayer, start, end, event.getPartialTicks());
                hit = hit.func_178788_d(start);
                LaserRenderer.drawRangeFinder(event.getWindow(), hand, hit.func_72433_c());
            }
        }
    }

    public static void drawRangeFinder(MainWindow sr, Hand hand, double range) {
        LaserRenderer.drawRangeFinder(sr, hand, (int)range + "");
    }

    public static void drawRangeFinder(MainWindow sr, Hand hand, String text) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int off = 8;
        FontRenderer font = ProxyClient.getMC().field_71466_p;
        off = hand == Hand.OFF_HAND ? -(font.func_78256_a(text) + 1 + off) : off;
        font.func_175063_a(text, (float)(sr.func_198107_o() / 2 + off), (float)(sr.func_198087_p() / 2), 0xFFFFFF);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

