/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.IProxy;
import de.cas_ual_ty.guncus.client.BakedModelGun;
import de.cas_ual_ty.guncus.client.BakedModelOptic;
import de.cas_ual_ty.guncus.client.HitmarkerRenderer;
import de.cas_ual_ty.guncus.client.LaserRenderer;
import de.cas_ual_ty.guncus.client.SightRenderer;
import de.cas_ual_ty.guncus.client.gui.GuiContainerBulletMaker;
import de.cas_ual_ty.guncus.client.gui.GuiContainerGunMaker;
import de.cas_ual_ty.guncus.client.gui.GuiContainerGunTable;
import de.cas_ual_ty.guncus.item.ItemAttachment;
import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import de.cas_ual_ty.guncus.itemgroup.ItemGroupShuffle;
import de.cas_ual_ty.guncus.network.MessageShoot;
import de.cas_ual_ty.guncus.registries.GunCusContainerTypes;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.network.NetworkEvent;

public class ProxyClient
implements IProxy {
    public static final Supplier<KeyBinding> BUTTON_AIM = () -> ProxyClient.getMC().field_71474_y.field_74313_G;
    public static final Supplier<KeyBinding> BUTTON_SHOOT = () -> ProxyClient.getMC().field_71474_y.field_74312_F;
    public static final Supplier<Boolean> BUTTON_AIM_DOWN = () -> BUTTON_AIM.get().func_151470_d();
    public static final Supplier<Boolean> BUTTON_SHOOT_DOWN = () -> BUTTON_SHOOT.get().func_151470_d();
    private static int[] shootTime = new int[GunCusUtility.HANDS.length];
    private static int inaccuracyTime = 0;
    private static int prevSelectedMain = -1;

    @Override
    public void registerModEventListeners(IEventBus bus) {
        bus.addListener(this::modelBake);
        bus.addListener(this::modelRegistry);
    }

    @Override
    public void registerForgeEventListeners(IEventBus bus) {
        bus.addListener(this::clientTick);
        bus.register((Object)new HitmarkerRenderer());
        bus.register((Object)new LaserRenderer());
        bus.register((Object)new SightRenderer());
    }

    @Override
    public void init() {
        ScreenManager.func_216911_a(GunCusContainerTypes.GUN_TABLE, GuiContainerGunTable::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.GUN_MAKER, GuiContainerGunMaker::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.BULLET_MAKER, GuiContainerBulletMaker::new);
    }

    @Override
    public void addHitmarker(PlayerEntity player) {
        HitmarkerRenderer.addHitmarker();
    }

    @Override
    public PlayerEntity getPlayerFromContext(@Nullable NetworkEvent.Context context) {
        return ProxyClient.getClientPlayer();
    }

    @Override
    public void shot(ItemStack itemStack, ItemGun gun, PlayerEntity player, Hand hand) {
        int fireRate = gun.calcCurrentFireRate(gun.getCurrentAttachments(itemStack));
        ProxyClient.shootTime[hand == Hand.MAIN_HAND ? 0 : 1] = fireRate;
        inaccuracyTime = Math.min(15, inaccuracyTime + 2 + fireRate);
    }

    public void modelBake(ModelBakeEvent event) {
        IBakedModel main;
        ModelResourceLocation mrl;
        for (ItemAttachment attachment : ItemAttachment.ATTACHMENTS_LIST) {
            Optic optic;
            if (attachment.getType() != EnumAttachmentType.OPTIC || (optic = (Optic)attachment) == null || !optic.canAim()) continue;
            mrl = new ModelResourceLocation(optic.getRegistryName().toString(), "inventory");
            main = (IBakedModel)event.getModelRegistry().get(mrl);
            event.getModelRegistry().put(mrl, new BakedModelOptic(main));
        }
        for (ItemGun gun : ItemGun.GUNS_LIST) {
            IBakedModel[][] models = new IBakedModel[EnumAttachmentType.LENGTH][];
            for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
                int i = type.getSlot();
                models[i] = new IBakedModel[gun.getAmmountForSlot(type)];
                for (int j = 0; j < models[i].length; ++j) {
                    ItemAttachment attachment = gun.getAttachment(type, j);
                    if (attachment == null || !attachment.shouldLoadModel()) continue;
                    models[i][j] = (IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
            mrl = new ModelResourceLocation(gun.getRegistryName().toString(), "inventory");
            main = (IBakedModel)event.getModelRegistry().get(mrl);
            MatrixStack stack = new MatrixStack();
            ((IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(gun.getRegistryName().toString() + "/aim", "inventory"))).handlePerspective(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, stack);
            Matrix4f aimMatrix = stack.func_227866_c_().func_227870_a_();
            event.getModelRegistry().put(mrl, new BakedModelGun(main, models, aimMatrix));
        }
    }

    public void modelRegistry(ModelRegistryEvent event) {
        for (ItemGun gun : ItemGun.GUNS_LIST) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/gun", "inventory"));
            for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
                for (int i = 0; i < gun.getAmmountForSlot(type); ++i) {
                    ItemAttachment attachment = gun.getAttachment(type, i);
                    if (attachment == null || !attachment.shouldLoadModel()) continue;
                    ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/aim", "inventory"));
        }
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemGun gun;
            ItemStack itemStack;
            PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
            if (entityPlayer == null) {
                return;
            }
            int i = 0;
            for (Hand hand : GunCusUtility.HANDS) {
                if (shootTime[i] > 0) {
                    int n = i;
                    shootTime[n] = shootTime[n] - 1;
                }
                if ((itemStack = entityPlayer.func_184586_b(hand)).func_77973_b() instanceof ItemGun) {
                    gun = (ItemGun)itemStack.func_77973_b();
                    if (gun.getNBTIsReloading(itemStack)) {
                        ProxyClient.shootTime[i] = 1;
                    } else if (hand == Hand.MAIN_HAND && entityPlayer.field_71071_by.field_70461_c != prevSelectedMain) {
                        int n = i;
                        shootTime[n] = shootTime[n] + gun.calcCurrentSwitchTime(gun.getCurrentAttachments(itemStack));
                    }
                }
                ++i;
            }
            prevSelectedMain = entityPlayer.field_71071_by.field_70461_c;
            if (inaccuracyTime > 0) {
                --inaccuracyTime;
            }
            if (BUTTON_SHOOT_DOWN.get().booleanValue() && (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun)) {
                boolean aiming = false;
                if (BUTTON_AIM_DOWN.get().booleanValue() && !entityPlayer.func_70051_ag() && entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun && entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    Optic optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                    aiming = optic.canAim();
                }
                i = 0;
                int handsInt = 0;
                for (i = 0; i < shootTime.length; ++i) {
                    if (!(entityPlayer.func_184586_b(GunCusUtility.HANDS[i]).func_77973_b() instanceof ItemGun) || shootTime[i] > 0) continue;
                    handsInt += i + 1;
                }
                if (handsInt > 0) {
                    GunCus.channel.sendToServer((Object)new MessageShoot(aiming, inaccuracyTime, handsInt));
                    ItemGun.tryShoot(entityPlayer, aiming, inaccuracyTime, GunCusUtility.intToHands(handsInt));
                }
            }
            for (ItemGroupShuffle group : ItemGroupShuffle.GROUPS_LIST) {
                group.tick();
            }
        }
    }

    public static void drawDrawFullscreenImage(ResourceLocation rl, int texWidth, int texHeight, MainWindow sr) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        ProxyClient.getMC().func_110434_K().func_110577_a(rl);
        double x = sr.func_198107_o();
        double y = sr.func_198087_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder b = tessellator.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        b.func_225582_a_(x * 0.5 - 2.0 * y, y, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        b.func_225582_a_(x * 0.5 + 2.0 * y, y, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        b.func_225582_a_(x * 0.5 + 2.0 * y, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        b.func_225582_a_(x * 0.5 - 2.0 * y, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.popMatrix();
    }

    public static Minecraft getMC() {
        return Minecraft.func_71410_x();
    }

    @Nullable
    public static PlayerEntity getClientPlayer() {
        return ProxyClient.getMC().field_71439_g;
    }
}

