/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import de.cas_ual_ty.guncus.client.ProxyClient;
import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.item.attachments.Accessory;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import net.minecraft.client.MainWindow;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SightRenderer {
    @SubscribeEvent
    public void fovUpdate(FOVUpdateEvent event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (entityPlayer != null && ProxyClient.BUTTON_AIM_DOWN.get().booleanValue() && !entityPlayer.func_70051_ag()) {
            Optic optic = null;
            float modifier = 1.0f;
            float extra = 0.0f;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                if (entityPlayer.func_184592_cb().func_190926_b()) {
                    ItemStack itemStack = entityPlayer.func_184614_ca();
                    ItemGun gun = (ItemGun)itemStack.func_77973_b();
                    if (gun.getNBTCanAimGun(itemStack)) {
                        optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                    }
                    if (optic != null && gun.isNBTAccessoryTurnedOn(itemStack) && !gun.getAttachment(itemStack, EnumAttachmentType.ACCESSORY).isDefault()) {
                        Accessory accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                        if (optic.isCompatibleWithMagnifiers()) {
                            modifier = accessory.getZoomModifier();
                        }
                        if (optic.isCompatibleWithExtraZoom()) {
                            extra = accessory.getExtraZoom();
                        }
                    }
                }
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                optic = (Optic)itemStack.func_77973_b();
            }
            if (optic != null && optic.canAim()) {
                event.setNewfov(SightRenderer.calculateFov(optic.getZoom() * modifier + 0.1f + extra, event.getFov()));
            }
        }
    }

    public static float calculateFov(float zoom, float fov) {
        return (float)Math.atan(Math.tan(fov) / (double)zoom);
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null) {
            Optic optic = null;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                ItemStack itemStack;
                ItemGun gun;
                if (entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                }
                event.setCanceled(true);
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                optic = (Optic)entityPlayer.func_184614_ca().func_77973_b();
            }
            if (optic != null && optic.canAim() && !entityPlayer.func_70051_ag() && ProxyClient.BUTTON_AIM_DOWN.get().booleanValue()) {
                SightRenderer.drawSight(optic, event.getWindow());
                if (!event.isCanceled()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void drawSight(Optic optic, MainWindow sr) {
        ProxyClient.drawDrawFullscreenImage(optic.getOverlay(), 1024, 256, sr);
    }
}

