/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.container;

import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.registries.GunCusBlocks;
import de.cas_ual_ty.guncus.registries.GunCusContainerTypes;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerGunMaker
extends Container {
    public final Inventory inventory = new Inventory(4);
    public final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 4, 1);
    public final Slot ironSlot;
    public final Slot goldSlot;
    public final Slot redstoneSlot;
    public final Slot ironSlotS;
    public final Slot goldSlotS;
    public final Slot redstoneSlotS;
    public final ArrayList<Slot> slots;
    public final Slot gunSlot;
    public final Slot gunSlotS;
    public final PlayerEntity player;
    protected BlockPos pos = null;
    protected IWorldPosCallable worldPosCallable;
    private boolean wasGunIn = false;
    private boolean wasChanging = false;

    public ContainerGunMaker(int windowId, PlayerInventory playerInv) {
        super(GunCusContainerTypes.GUN_MAKER, windowId);
        this.player = playerInv.field_70458_d;
        int slotX1 = 56;
        int slotX2 = 116;
        int slotY1 = 48;
        int slotY2 = 22;
        this.slots = new ArrayList(8);
        this.ironSlot = new Slot((IInventory)this.craftMatrix, 0, 38, 48){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151042_j;
            }
        };
        this.slots.add(this.ironSlot);
        this.goldSlot = new Slot((IInventory)this.craftMatrix, 1, 56, 48){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151043_k;
            }
        };
        this.slots.add(this.goldSlot);
        this.redstoneSlot = new Slot((IInventory)this.craftMatrix, 2, 74, 48){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151137_ax;
            }
        };
        this.slots.add(this.redstoneSlot);
        this.ironSlotS = new Slot((IInventory)this.inventory, 0, 38, 22){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        };
        this.slots.add(this.ironSlotS);
        this.goldSlotS = new Slot((IInventory)this.inventory, 1, 56, 22){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        };
        this.slots.add(this.goldSlotS);
        this.redstoneSlotS = new Slot((IInventory)this.inventory, 2, 74, 22){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        };
        this.slots.add(this.redstoneSlotS);
        this.gunSlot = new Slot((IInventory)this.craftMatrix, 3, 116, 48){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        };
        this.slots.add(this.gunSlot);
        this.gunSlotS = new Slot((IInventory)this.inventory, 3, 116, 22){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        };
        this.slots.add(this.gunSlotS);
        for (Slot s : this.slots) {
            this.func_75146_a(s);
        }
        for (int y1 = 0; y1 < 3; ++y1) {
            for (int x1 = 0; x1 < 9; ++x1) {
                this.func_75146_a(new Slot((IInventory)playerInv, x1 + y1 * 9 + 9, 8 + x1 * 18, 84 + y1 * 18));
            }
        }
        for (int x1 = 0; x1 < 9; ++x1) {
            this.func_75146_a(new Slot((IInventory)playerInv, x1, 8 + x1 * 18, 142));
        }
        this.setGun(ItemGun.GUNS_LIST.get(0));
    }

    public ContainerGunMaker(int windowId, PlayerInventory playerInv, BlockPos pos) {
        this(windowId, playerInv);
        this.pos = pos;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)this.player.field_70170_p, (BlockPos)this.pos);
    }

    public ContainerGunMaker(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(windowId, playerInv, extraData.func_179259_c());
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.craftMatrix) {
            Slot slotI;
            Slot slotS;
            if (this.wasChanging) {
                return;
            }
            this.wasChanging = true;
            if (this.wasGunIn && !this.gunSlot.func_75216_d()) {
                for (int i = 3; i < 6; ++i) {
                    slotS = this.slots.get(i);
                    slotI = this.slots.get(i - 3);
                    slotI.func_75211_c().func_190918_g(slotS.func_75211_c().func_190916_E());
                }
            }
            boolean full = true;
            for (int i = 3; i < 6; ++i) {
                slotS = this.slots.get(i);
                slotI = this.slots.get(i - 3);
                if (slotS.func_75211_c().func_190916_E() <= slotI.func_75211_c().func_190916_E()) continue;
                full = false;
                break;
            }
            this.wasGunIn = full;
            if (full) {
                this.gunSlot.func_75215_d(new ItemStack((IItemProvider)this.gunSlotS.func_75211_c().func_77973_b()));
            } else {
                this.gunSlot.func_75215_d(ItemStack.field_190927_a);
            }
            this.wasChanging = false;
        }
        super.func_75130_a(inventoryIn);
    }

    public void setGun(ItemGun gun) {
        this.gunSlotS.func_75215_d(new ItemStack((IItemProvider)gun));
        this.ironSlotS.func_75215_d(new ItemStack((IItemProvider)Items.field_151042_j, gun.ironAmt));
        this.goldSlotS.func_75215_d(new ItemStack((IItemProvider)Items.field_151043_k, gun.goldAmt));
        this.redstoneSlotS.func_75215_d(new ItemStack((IItemProvider)Items.field_151137_ax, gun.redstoneAmt));
        this.wasGunIn = false;
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void setGun(String modid, String name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name));
        if (item instanceof ItemGun) {
            this.setGun((ItemGun)item);
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.pos == null || Container.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)GunCusBlocks.GUN_MAKER);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack itemStack = slot.func_75211_c();
        if (index >= 8) {
            Slot ingredientSlot = null;
            if (itemStack.func_77973_b() == Items.field_151042_j) {
                ingredientSlot = this.ironSlot;
            } else if (itemStack.func_77973_b() == Items.field_151043_k) {
                ingredientSlot = this.goldSlot;
            } else if (itemStack.func_77973_b() == Items.field_151137_ax) {
                ingredientSlot = this.redstoneSlot;
            }
            if (ingredientSlot != null) {
                int alreadyIn = ingredientSlot.func_75211_c().func_190916_E();
                int available = slot.func_75211_c().func_190916_E();
                int toTransfer = Math.min(alreadyIn + available, 64) - alreadyIn;
                if (ingredientSlot.func_75216_d()) {
                    ingredientSlot.func_75211_c().func_190917_f(toTransfer);
                    slot.func_75211_c().func_190918_g(toTransfer);
                } else {
                    ingredientSlot.func_75215_d(itemStack);
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            }
        } else if (playerIn.field_71071_by.func_70441_a(itemStack)) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        if (this.ironSlot.func_75216_d()) {
            playerIn.func_71019_a(this.ironSlot.func_75211_c(), false);
        }
        if (this.goldSlot.func_75216_d()) {
            playerIn.func_71019_a(this.goldSlot.func_75211_c(), false);
        }
        if (this.redstoneSlot.func_75216_d()) {
            playerIn.func_71019_a(this.redstoneSlot.func_75211_c(), false);
        }
        super.func_75134_a(playerIn);
    }
}

