/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item;

import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class ItemAttachment
extends Item {
    public static final ArrayList<ItemAttachment> ATTACHMENTS_LIST = new ArrayList();
    protected float zoomModifier = 1.0f;
    protected float extraZoom = 0.0f;
    protected float extraDamage = 0.0f;
    protected float driftModifier = 1.0f;
    protected float speedModifier = 1.0f;
    protected float spreadModifierVertical = 1.0f;
    protected float spreadModifierHorizontal = 1.0f;
    protected float inaccuracyModifier = 1.0f;
    protected float inaccuracyModifierMoving = 1.0f;
    protected float inaccuracyModifierStill = 1.0f;

    public ItemAttachment(Item.Properties properties) {
        super(properties);
        ATTACHMENTS_LIST.add(this);
    }

    public ItemAttachment setDefaultTradeable() {
        new RandomTradeBuilder(2, 50, 0.05f).setEmeraldPriceFor(16, this).registerLevel(2);
        return this;
    }

    public abstract EnumAttachmentType getType();

    public float getZoomModifier() {
        return this.zoomModifier;
    }

    public float getExtraZoom() {
        return this.extraZoom;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public float getDriftModifier() {
        return this.driftModifier;
    }

    public float getSpeedModifier() {
        return this.speedModifier;
    }

    public float getSpreadModifierVertical() {
        return this.spreadModifierVertical;
    }

    public float getSpreadModifierHorizontal() {
        return this.spreadModifierHorizontal;
    }

    public float getInaccuracyModifier() {
        return this.inaccuracyModifier;
    }

    public float getInaccuracyModifierMoving() {
        return this.inaccuracyModifierMoving;
    }

    public float getInaccuracyModifierStill() {
        return this.inaccuracyModifierStill;
    }

    public ItemAttachment setZoomModifier(float zoomModifier) {
        this.zoomModifier = zoomModifier;
        return this;
    }

    public ItemAttachment setExtraZoom(float extraZoom) {
        this.extraZoom = extraZoom;
        return this;
    }

    public ItemAttachment setExtraDamage(float extraDamage) {
        this.extraDamage = extraDamage;
        return this;
    }

    public ItemAttachment setDriftModifier(float driftModifier) {
        this.driftModifier = driftModifier;
        return this;
    }

    public ItemAttachment setSpeedModifier(float speedModifier) {
        this.speedModifier = speedModifier;
        return this;
    }

    public ItemAttachment setSpreadModifierVertical(float spreadModifierVertical) {
        this.spreadModifierVertical = spreadModifierVertical;
        return this;
    }

    public ItemAttachment setSpreadModifierHorizontal(float spreadModifierHorizontal) {
        this.spreadModifierHorizontal = spreadModifierHorizontal;
        return this;
    }

    public ItemAttachment setInaccuracyModifier(float inaccuracyModifier) {
        this.inaccuracyModifier = inaccuracyModifier;
        return this;
    }

    public ItemAttachment setInaccuracyModifierMoving(float inaccuracyModifierMoving) {
        this.inaccuracyModifierMoving = inaccuracyModifierMoving;
        return this;
    }

    public ItemAttachment setInaccuracyModifierStill(float inaccuracyModifierStill) {
        this.inaccuracyModifierStill = inaccuracyModifierStill;
        return this;
    }

    public final ItemAttachment getDefaultOfSameSlot() {
        return EnumAttachmentType.getSlot(this.getSlot()).getDefault();
    }

    public boolean isDefault() {
        return this == this.getType().getDefault();
    }

    public boolean shouldRender() {
        return !this.isDefault();
    }

    public boolean shouldLoadModel() {
        return this.shouldRender();
    }

    public int getSlot() {
        return this.getType().getSlot();
    }

    public String getAttachmentRegistryName() {
        return this.isDefault() ? "" : this.getRegistryName().toString();
    }

    public String func_77658_a() {
        return this.isDefault() ? "item.guncus." + this.getType().getKey() + "_default" : super.func_77658_a();
    }

    public String getStringSuffix() {
        return this.isDefault() ? "" : "_" + this.getRegistryName().func_110623_a().toString();
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ITextComponent type = this.getType().getDisplayName().func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        ITextComponent attachment = ItemAttachment.getAttachmentTranslated(false).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(type.func_150254_d() + " " + attachment.func_150254_d()));
    }

    public ITextComponent getInformationString() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    }

    public static ITextComponent getAttachmentTranslated(boolean plural) {
        return new TranslationTextComponent("local.guncus.attachment" + (plural ? "s" : ""), new Object[0]);
    }

    public static ItemAttachment[][] buildDefaultArray() {
        ItemAttachment[][] attachments = new ItemAttachment[EnumAttachmentType.LENGTH][];
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i] = new ItemAttachment[]{EnumAttachmentType.getSlot(i).getDefault()};
        }
        return attachments;
    }
}

